/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.nativemem;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import org.simantics.nativemem.ProcessMemoryCounters;
import org.simantics.nativemem.internal.Arch;
import org.simantics.nativemem.internal.OS;
import org.simantics.nativemem.internal.Psapi32;
import org.simantics.nativemem.internal.Psapi64;

public class NativeMem {
    public static ProcessMemoryCounters getMemoryCounters(ProcessMemoryCounters out) {
        if (out == null) {
            out = new ProcessMemoryCounters();
        }
        OS os = OS.calculate();
        Arch arch = Arch.calculate();
        switch (os) {
            case WINDOWS: {
                WinNT.HANDLE proc = Kernel32.INSTANCE.GetCurrentProcess();
                switch (arch) {
                    case X86: {
                        Psapi32.PROCESS_MEMORY_COUNTERS_EX pmem = new Psapi32.PROCESS_MEMORY_COUNTERS_EX();
                        boolean ok = Psapi32.INSTANCE.GetProcessMemoryInfo(proc, pmem, pmem.size());
                        if (ok) {
                            pmem.writeTo(out);
                        }
                        return out;
                    }
                    case X86_64: {
                        Psapi64.PROCESS_MEMORY_COUNTERS_EX pmem = new Psapi64.PROCESS_MEMORY_COUNTERS_EX();
                        boolean ok = Psapi64.INSTANCE.GetProcessMemoryInfo(proc, pmem, pmem.size());
                        if (ok) {
                            pmem.writeTo(out);
                        }
                        return out;
                    }
                }
                throw new UnsupportedOperationException("Architecture " + (Object)((Object)arch) + " not supported on operating system " + (Object)((Object)os));
            }
        }
        throw new UnsupportedOperationException("Operating system " + (Object)((Object)os) + " not supported");
    }
}

