/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scenegraph.example;

import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JSlider;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.nodes.AnimatedSVGNode;
import org.simantics.scenegraph.g2d.nodes.GridNode;
import org.simantics.scenegraph.g2d.nodes.NavigationNode;
import org.simantics.scenegraph.g2d.nodes.RulerNode;
import org.simantics.scenegraph.g2d.nodes.ShapeNode;
import org.simantics.scenegraph.g2d.nodes.TransformNode;
import org.simantics.scenegraph.g2d.nodes.Trend2DNode;
import org.simantics.scenegraph.swing.ButtonNode;
import org.simantics.scenegraph.swing.LabelNode;
import org.simantics.scenegraph.swing.MonitorNode;
import org.simantics.scenegraph.swing.SliderNode;

public class SampleThread
implements Runnable {
    public G2DSceneGraph sg = new G2DSceneGraph();
    protected TransformNode transform = null;
    protected TransformNode transform2 = null;
    protected boolean interrupted = false;
    protected boolean rotate = true;
    protected float t1 = 0.0f;
    protected float t2 = 0.0f;

    public void start() {
        this.interrupted = false;
        Thread t = new Thread(this);
        t.start();
    }

    public void stop() {
        this.interrupted = true;
    }

    protected void close() {
    }

    protected boolean init() {
        return true;
    }

    private String loadSVG(String filename) throws IOException {
        String data = "";
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(filename)));
        while (reader.ready()) {
            data = String.valueOf(data) + reader.readLine();
        }
        reader.close();
        return data;
    }

    @Override
    public void run() {
        if (!this.init()) {
            return;
        }
        NavigationNode nav = (NavigationNode)this.sg.addNode(NavigationNode.class);
        GridNode grid = (GridNode)nav.addNode(GridNode.class);
        grid.setZIndex(1);
        AnimatedSVGNode svg1 = null;
        AnimatedSVGNode svg2 = null;
        AnimatedSVGNode svg3 = null;
        AnimatedSVGNode svg4 = null;
        try {
            String data = this.loadSVG("tynnyri.svg");
            svg1 = (AnimatedSVGNode)nav.addNode(AnimatedSVGNode.class);
            svg1.setZIndex(20);
            svg1.setData(data);
            svg1.setTransform(AffineTransform.getTranslateInstance(0.0, 150.0));
            svg1.useMipMap(Boolean.valueOf(false));
            svg2 = (AnimatedSVGNode)nav.addNode(AnimatedSVGNode.class);
            svg2.setZIndex(20);
            svg2.setData(data);
            svg2.setTransform(AffineTransform.getTranslateInstance(250.0, 150.0));
            svg2.useMipMap(Boolean.valueOf(false));
            svg3 = (AnimatedSVGNode)nav.addNode(AnimatedSVGNode.class);
            svg3.setZIndex(20);
            svg3.setData(data);
            svg3.setTransform(AffineTransform.getTranslateInstance(500.0, 150.0));
            svg3.useMipMap(Boolean.valueOf(false));
            svg4 = (AnimatedSVGNode)nav.addNode(AnimatedSVGNode.class);
            svg4.setZIndex(20);
            svg4.setData(data);
            svg4.setTransform(AffineTransform.getTranslateInstance(750.0, 150.0));
            svg4.useMipMap(Boolean.valueOf(false));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.transform = (TransformNode)nav.addNode(TransformNode.class);
        this.transform.setZIndex(3);
        AffineTransform at = new AffineTransform();
        at.translate(200.0, 200.0);
        this.transform.setTransform(at);
        ShapeNode box = (ShapeNode)this.transform.addNode(ShapeNode.class);
        box.setZIndex(1);
        box.setShape((Shape)new Rectangle2D.Double(-50.0, -50.0, 100.0, 100.0));
        MonitorNode cn = (MonitorNode)nav.addNode(MonitorNode.class);
        cn.setZIndex(2);
        cn.setTransform(AffineTransform.getTranslateInstance(100.0, 50.0));
        cn.setBounds(new Rectangle2D.Double(0.0, 0.0, 100.0, 25.0));
        final ButtonNode button = (ButtonNode)nav.addNode(ButtonNode.class);
        button.setZIndex(3);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SampleThread.this.rotate) {
                    button.setText("Start rotation");
                    SampleThread.this.rotate = false;
                } else {
                    button.setText("Stop rotation");
                    SampleThread.this.rotate = true;
                }
            }
        });
        button.setText("Stop rotation");
        button.setBounds(new Rectangle2D.Double(0.0, 0.0, 100.0, 20.0));
        button.setTransform(AffineTransform.getTranslateInstance(100.0, 75.0));
        SliderNode sn1 = (SliderNode)nav.addNode(SliderNode.class);
        sn1.setZIndex(4);
        sn1.setTransform(AffineTransform.getTranslateInstance(100.0, 100.0));
        sn1.setBounds(new Rectangle2D.Double(0.0, 0.0, 150.0, 50.0));
        sn1.setTitle("Rotation speed 1");
        sn1.setMaximum(100);
        sn1.setValue(20);
        sn1.setMajorTickSpacing(20);
        sn1.setMinorTickSpacing(5);
        sn1.setPaintTicks(true);
        JSlider slider2 = new JSlider();
        slider2.setBorder(BorderFactory.createTitledBorder("Rotation speed 2"));
        slider2.setMaximum(100);
        slider2.setValue(50);
        slider2.setMajorTickSpacing(20);
        slider2.setMinorTickSpacing(5);
        slider2.setPaintTicks(true);
        SliderNode sn2 = (SliderNode)nav.addNode(SliderNode.class);
        sn2.setZIndex(5);
        sn2.setTransform(AffineTransform.getTranslateInstance(250.0, 100.0));
        sn2.setBounds(new Rectangle2D.Double(0.0, 0.0, 150.0, 50.0));
        LabelNode cn2 = (LabelNode)nav.addNode(LabelNode.class);
        cn2.setZIndex(6);
        cn2.setText("Name");
        cn2.setBounds(new Rectangle2D.Double(0.0, 0.0, 100.0, 25.0));
        cn2.setTransform(AffineTransform.getTranslateInstance(100.0, 30.0));
        MonitorNode cn3 = (MonitorNode)nav.addNode(MonitorNode.class);
        cn3.setZIndex(7);
        cn3.setTransform(AffineTransform.getTranslateInstance(250.0, 50.0));
        cn3.setBounds(new Rectangle2D.Double(0.0, 0.0, 100.0, 25.0));
        LabelNode cn4 = (LabelNode)nav.addNode(LabelNode.class);
        cn4.setZIndex(8);
        cn4.setText("Phone number");
        cn4.setTransform(AffineTransform.getTranslateInstance(250.0, 30.0));
        cn4.setBounds(new Rectangle2D.Double(0.0, 0.0, 100.0, 25.0));
        this.transform2 = (TransformNode)this.transform.addNode(TransformNode.class);
        this.transform2.setZIndex(9);
        ShapeNode box2 = (ShapeNode)this.transform2.addNode(ShapeNode.class);
        box2.setShape((Shape)new Rectangle2D.Double(-30.0, -30.0, 60.0, 60.0));
        Trend2DNode trend = (Trend2DNode)nav.addNode(Trend2DNode.class);
        trend.setZIndex(10);
        trend.setBounds((Rectangle2D)new Rectangle2D.Double(0.0, 0.0, 200.0, 200.0));
        trend.setPosition(400, 200);
        ArrayList<Trend2DNode.TrendPoint> points = new ArrayList<Trend2DNode.TrendPoint>();
        int p = 0;
        p = 0;
        while (p < 20) {
            points.add(new Trend2DNode.TrendPoint((double)p++, Math.random()));
        }
        trend.updatePoints(points);
        RulerNode ruler = (RulerNode)nav.addNode(RulerNode.class);
        ruler.setZIndex(11);
        String script1 = "var y = 620;\nvar height = 285*level/100;\nvar r = (2*level).toString(16); var b = (2*(100-level)).toString(16);\nvar color = \"#\"+(r.length == 1 ? \"0\"+r : r)+\"00\"+(b.length == 1 ? \"0\"+b : b);\nsvg.getElement(\"fill\").setAttribute(\"fill\", 0, color)\nsvg.getElement(\"upperlevel\").setAttribute(\"fill\", 0, color)\nsvg.getElement(\"bottom\").setAttribute(\"fill\", 0, color)\nsvg.getElement(\"fill\").setAttribute(\"y\", 1, y-height);\nsvg.getElement(\"fill\").setAttribute(\"height\", 1, height);\nsvg.getElement(\"upperlevel\").setAttribute(\"transform\", 1, \"translate(1.4285587, \"+(280-height)+\")\");\n";
        String script2 = "var level = (time/10)%200;\nif(level > 100) level = 200 - level;\nvar y = 620;\nvar height = 285*level/100;\nsvg.getElement(\"fill\").setAttribute(\"y\", 1, y-height);\nsvg.getElement(\"fill\").setAttribute(\"height\", 1, height);\nsvg.getElement(\"upperlevel\").setAttribute(\"transform\", 1, \"translate(1.4285587, \"+(280-height)+\")\");\n";
        sn1.setActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Integer v = Integer.parseInt(e.getActionCommand());
                SampleThread.this.t1 = (float)v.intValue() / 1000.0f;
            }
        });
        sn2.setActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Integer v = Integer.parseInt(e.getActionCommand());
                SampleThread.this.t2 = (float)v.intValue() / 1000.0f;
            }
        });
        svg1.setScript(script1);
        svg2.setScript(script1);
        while (!this.interrupted) {
            if (this.rotate) {
                this.transform.rotate((double)this.t1);
                this.transform2.rotate((double)this.t2);
                points.add(new Trend2DNode.TrendPoint((double)p++, Math.random()));
                trend.updatePoints(points);
            }
            svg1.setValue("level", (Object)new Double(this.t1 * 1000.0f));
            svg2.setValue("level", (Object)new Double(this.t2 * 1000.0f));
            svg3.animate(script2);
            svg4.animate(script2);
            this.repaint();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.close();
    }

    public void repaint() {
    }
}

