/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.ui.workbench.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.DoubleClickEvent;
import org.simantics.ui.DoubleClickExtensionManager;
import org.simantics.ui.IDoubleClickExtension;
import org.simantics.ui.dialogs.ActionChooserDialog;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.ui.workbench.action.IWorkbenchActionHints;
import org.simantics.utils.ui.action.IPriorityAction;

public class ChooseActionRequest
extends ReadRequest {
    protected Shell parent;
    protected Object widget;
    protected Object input;
    protected String perspectiveId;
    protected IPriorityAction[] actions;
    protected String resourceName;
    protected boolean rememberAction;
    protected boolean alwaysAsk;
    protected boolean neverPromptForAction;

    public ChooseActionRequest(Shell parent, Object input, String forPerspectiveId) {
        this(parent, null, input, forPerspectiveId, true, false);
    }

    public ChooseActionRequest(Shell parent, Object widget, Object input, String forPerspectiveId) {
        this(parent, widget, input, forPerspectiveId, true, false);
    }

    public ChooseActionRequest(Shell parent, Object input, String forPerspectiveId, boolean rememberAction, boolean alwaysAsk) {
        this(parent, null, input, forPerspectiveId, true, false);
    }

    public ChooseActionRequest(Shell parent, Object widget, Object input, String forPerspectiveId, boolean rememberAction, boolean alwaysAsk) {
        this(parent, widget, input, forPerspectiveId, rememberAction, alwaysAsk, false);
    }

    public ChooseActionRequest(Shell parent, Object widget, Object input, String forPerspectiveId, boolean rememberAction, boolean alwaysAsk, boolean neverPromptForAction) {
        if (input == null) {
            throw new NullPointerException("null input");
        }
        this.parent = parent;
        this.widget = widget;
        this.input = input;
        this.perspectiveId = forPerspectiveId;
        this.rememberAction = rememberAction;
        this.alwaysAsk = alwaysAsk;
        this.neverPromptForAction = neverPromptForAction;
    }

    private String getResourceName(ReadGraph graph, Object resource) throws DatabaseException {
        Resource r = ResourceAdaptionUtils.toSingleResource(resource);
        if (r == null) {
            return resource.toString();
        }
        return NameUtils.getSafeName((ReadGraph)graph, (Resource)r);
    }

    public void run(ReadGraph graph) throws DatabaseException {
        this.resourceName = this.getResourceName(graph, this.input);
        this.actions = ChooseActionRequest.findActions(graph, this.widget, this.input, this.perspectiveId, this.rememberAction, this.alwaysAsk);
        if (this.actions != null) {
            this.scheduleChooseAction(this.actions);
        }
    }

    public void scheduleChooseAction(final IPriorityAction[] actions) {
        if (this.parent == null) {
            if (actions.length > 0) {
                actions[0].run();
                return;
            }
        } else {
            this.parent.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ChooseActionRequest.this.parent.isDisposed()) {
                        return;
                    }
                    IAction action = ChooseActionRequest.chooseAction(ChooseActionRequest.this.parent, actions, ChooseActionRequest.this.resourceName, ChooseActionRequest.this.neverPromptForAction);
                    if (action != null) {
                        action.run();
                        return;
                    }
                }
            });
        }
    }

    public static IPriorityAction[] findActions(ReadGraph g, Resource r, String forPerspectiveId) throws DatabaseException {
        return ChooseActionRequest.findActions(g, null, r, forPerspectiveId, true, false);
    }

    public static IPriorityAction[] findActions(ReadGraph g, Object widget, Resource r, String forPerspectiveId) throws DatabaseException {
        return ChooseActionRequest.findActions(g, widget, r, forPerspectiveId, true, false);
    }

    public static IPriorityAction[] findActions(ReadGraph g, Object r, String forPerspectiveId, boolean rememberAction, boolean alwaysAsk) throws DatabaseException {
        return ChooseActionRequest.findActions(g, null, r, forPerspectiveId, true, false);
    }

    public static IPriorityAction[] findActions(ReadGraph g, Object widget, Object r, String forPerspectiveId, boolean rememberAction, boolean alwaysAsk) throws DatabaseException {
        DoubleClickEvent dbe = new DoubleClickEvent(ChooseActionRequest.class, g, r);
        dbe.getHintContext().setHint(IWorkbenchActionHints.KEY_CURRENTPERSPECTIVE, (Object)forPerspectiveId);
        dbe.getHintContext().setHint(IWorkbenchActionHints.KEY_REMEMBER, (Object)rememberAction);
        dbe.getHintContext().setHint(IWorkbenchActionHints.KEY_ALWAYS_ASK, (Object)alwaysAsk);
        if (widget != null) {
            dbe.getHintContext().setHint(IWorkbenchActionHints.KEY_WIDGET, widget);
        }
        IDoubleClickExtension[] iDoubleClickExtensionArray = DoubleClickExtensionManager.getInstance().getExtensions();
        int n = iDoubleClickExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDoubleClickExtension ext = iDoubleClickExtensionArray[n2];
            ext.getAction().doubleClickEvent(dbe);
            if (dbe.isConsumed()) break;
            ++n2;
        }
        return dbe.getOrderedActions();
    }

    public static IAction chooseAction(Shell parentShell, IPriorityAction[] actions, String resourceName) {
        return ChooseActionRequest.chooseAction(parentShell, actions, resourceName, false);
    }

    public static IAction chooseAction(Shell parentShell, IPriorityAction[] actions, String resourceName, boolean neverPromptForAction) {
        int len = actions.length;
        if (len == 1) {
            return actions[0].getPriority() >= 0 ? actions[0] : null;
        }
        if (len > 1) {
            if (actions[0].getPriority() > actions[1].getPriority()) {
                return actions[0].getPriority() >= 0 ? actions[0] : null;
            }
            if (neverPromptForAction) {
                return null;
            }
            ActionChooserDialog dlg = new ActionChooserDialog(parentShell, actions, "Choose Action", "Choose action for '" + resourceName + "'");
            int ret = dlg.open();
            if (ret != 0) {
                return null;
            }
            return dlg.getChosenAction();
        }
        return null;
    }
}

