/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.datastructures;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MapList<L, R> {
    public static final MapList EMPTY_MAPLIST = new MapList(){
        private static final String IMMUTABLE_MSG = "Cannot modify immutable empty MapList";

        public void add(Object key) {
            throw new UnsupportedOperationException(IMMUTABLE_MSG);
        }

        public void add(Object key, int index, Object value) {
            throw new UnsupportedOperationException(IMMUTABLE_MSG);
        }

        public void add(Object key, Object value) {
            throw new UnsupportedOperationException(IMMUTABLE_MSG);
        }

        public void addAll(Object key, Collection values) {
            throw new UnsupportedOperationException(IMMUTABLE_MSG);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException(IMMUTABLE_MSG);
        }

        public boolean remove(Object key) {
            throw new UnsupportedOperationException(IMMUTABLE_MSG);
        }

        public boolean remove(Object key, Object value) {
            throw new UnsupportedOperationException(IMMUTABLE_MSG);
        }
    };
    protected Map<L, List<R>> lists;

    public static <L, R> MapList<L, R> emptyMapList() {
        return EMPTY_MAPLIST;
    }

    public MapList() {
        this.lists = new THashMap();
    }

    public MapList(Class<?> mapClass) {
        try {
            this.lists = (Map)mapClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public MapList(MapList<L, R> copyFrom) {
        for (Map.Entry<L, List<R>> e : copyFrom.lists.entrySet()) {
            this.lists.put(e.getKey(), new ArrayList(e.getValue()));
        }
    }

    public static <L, R> MapList<L, R> use(Map<L, List<R>> map) {
        MapList<L, R> result = new MapList<L, R>();
        result.lists = map;
        return result;
    }

    public void add(L key) {
        this.getOrCreateList(key);
    }

    public void add(L key, R value) {
        ArrayList<R> list = this.getOrCreateList(key);
        list.add(value);
    }

    public void add(L key, int index, R value) {
        ArrayList<R> list = this.getOrCreateList(key);
        list.add(index, value);
    }

    public void addAll(L key, Collection<R> values) {
        ArrayList<R> list = this.getOrCreateList(key);
        list.addAll(values);
    }

    private ArrayList<R> getOrCreateList(L key) {
        ArrayList list = (ArrayList)this.lists.get(key);
        if (list == null) {
            list = new ArrayList(1);
            this.lists.put(key, list);
        }
        return list;
    }

    private List<R> getList(L key) {
        return this.lists.get(key);
    }

    public boolean remove(L key, R value) {
        List<R> list = this.getList(key);
        if (list == null) {
            return false;
        }
        boolean result = list.remove(value);
        if (list.size() == 0) {
            this.lists.remove(key);
        }
        return result;
    }

    public boolean remove(L key) {
        List<R> list = this.getList(key);
        if (list == null) {
            return false;
        }
        this.lists.remove(key);
        return true;
    }

    public void clear() {
        this.lists.clear();
    }

    public L[] getKeys(L[] list) {
        return this.lists.keySet().toArray(list);
    }

    public Set<L> getKeys() {
        return this.lists.keySet();
    }

    public int getKeySize() {
        return this.lists.size();
    }

    public boolean containsKey(L key) {
        return this.lists.containsKey(key);
    }

    public boolean contains(L key, R obj) {
        List<R> l = this.lists.get(key);
        if (l == null) {
            return false;
        }
        return l.contains(obj);
    }

    public R[] getValues(L key, R[] list) {
        List<R> l = this.lists.get(key);
        if (l == null) {
            return null;
        }
        return l.toArray(list);
    }

    public int getAtMostValues(L key, R[] list) {
        List<R> l = this.lists.get(key);
        if (l == null) {
            return 0;
        }
        int valueCount = l.size();
        int size = Math.min(valueCount, list.length);
        int i = 0;
        while (i < size) {
            list[i] = l.get(i);
            ++i;
        }
        return valueCount;
    }

    public List<R> getValuesUnsafe(L key) {
        List<R> l = this.lists.get(key);
        return l != null ? l : Collections.emptyList();
    }

    public List<R> getValues(L key) {
        List<R> l = this.lists.get(key);
        if (l == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(l);
    }

    public List<R> getValuesSnapshot(L key) {
        List<R> l = this.lists.get(key);
        if (l == null) {
            return Collections.emptyList();
        }
        return new ArrayList<R>(l);
    }

    public List<R> getAllValuesSnapshot() {
        return this.getAllValuesSnapshot(null);
    }

    public List<R> getAllValuesSnapshot(List<R> result) {
        if (result == null) {
            result = new ArrayList<R>();
        }
        for (List<R> right : this.lists.values()) {
            result.addAll(right);
        }
        return result;
    }

    public boolean isEmpty() {
        return this.lists.isEmpty();
    }

    public void makeImmutable() {
        for (Map.Entry<L, List<R>> e : this.lists.entrySet()) {
            this.lists.put(e.getKey(), Collections.unmodifiableList(e.getValue()));
        }
        this.lists = Collections.unmodifiableMap(this.lists);
    }
}

