/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.top;

import java.util.ArrayList;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EEnforce;
import org.simantics.scl.compiler.elaboration.expressions.EFieldAccess;
import org.simantics.scl.compiler.elaboration.expressions.ELambda;
import org.simantics.scl.compiler.elaboration.expressions.ERuleset;
import org.simantics.scl.compiler.elaboration.expressions.ESelect;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLambda;
import org.simantics.scl.compiler.elaboration.expressions.EWhen;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.internal.elaboration.utils.ExpressionDecorator;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class ToplevelEffectDecorator
implements ExpressionDecorator {
    ErrorLog errorLog;
    Environment environment;
    private static final TCon R = Types.con("R/R", "R");

    public ToplevelEffectDecorator(ErrorLog errorLog, Environment environment) {
        this.errorLog = errorLog;
        this.environment = environment;
    }

    private static Expression decorate(SCLValue transactionFunction, Type effect, Expression expression) {
        Variable var = new Variable("_");
        var.setType(Types.UNIT);
        Expression trans = new EApply(expression.getLocation(), Types.PROC, (Expression)new EConstant(transactionFunction, expression.getType()), new ESimpleLambda(9223372034707292160L, var, effect, expression));
        if (expression instanceof EApply) {
            EApply apply = (EApply)expression;
            trans = apply.toANormalForm(trans);
        }
        return trans;
    }

    @Override
    public Expression decorate(Expression expression) {
        if (expression instanceof EApply) {
            return this.decorateByEffect(expression, ((EApply)expression).getLocalEffect());
        }
        if (expression instanceof ESelect || expression instanceof EEnforce || expression instanceof EWhen || expression instanceof EFieldAccess || expression instanceof ERuleset) {
            return this.decorateByEffect(expression, expression.getEffect());
        }
        return expression;
    }

    private Expression decorateByEffect(Expression expression, Type effect) {
        SCLValue transactionFunction;
        Name name;
        if (effect == Types.NO_EFFECTS) {
            return expression;
        }
        ArrayList<TCon> concreteEffects = new ArrayList<TCon>();
        effect.collectConcreteEffects(concreteEffects);
        if (concreteEffects.contains(Types.WRITE_GRAPH)) {
            name = Names.Simantics_DB_syncWrite;
            transactionFunction = this.environment.getValue(name);
            if (transactionFunction == null) {
                this.errorLog.log(expression.location, "Cannot locate " + name);
                return expression;
            }
            expression = ToplevelEffectDecorator.decorate(transactionFunction, Types.WRITE_GRAPH, expression);
        } else if (concreteEffects.contains(Types.READ_GRAPH)) {
            name = Names.Simantics_DB_syncRead;
            transactionFunction = this.environment.getValue(name);
            if (transactionFunction == null) {
                this.errorLog.log(expression.location, "Cannot locate " + name);
                return expression;
            }
            expression = ToplevelEffectDecorator.decorate(transactionFunction, Types.READ_GRAPH, expression);
        }
        if (concreteEffects.contains(R)) {
            name = Names.R_R_runR;
            transactionFunction = this.environment.getValue(name);
            if (transactionFunction == null) {
                this.errorLog.log(expression.location, "Cannot locate " + name);
                return expression;
            }
            expression = ToplevelEffectDecorator.decorate(transactionFunction, R, expression);
        }
        if (concreteEffects.contains(Types.RANDOM)) {
            name = Names.Random_runRandom;
            transactionFunction = this.environment.getValue(name);
            if (transactionFunction == null) {
                this.errorLog.log(expression.location, "Cannot locate " + name);
                return expression;
            }
            expression = ToplevelEffectDecorator.decorate(transactionFunction, Types.RANDOM, expression);
        }
        return expression;
    }

    @Override
    public boolean decorateSubstructure(Expression expression) {
        return !(expression instanceof ELambda) && !(expression instanceof ESimpleLambda);
    }
}

