/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.runtime;

import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.rules.TransformationRule;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.GlobalOnlyEnvironment;
import org.simantics.scl.compiler.internal.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.internal.codegen.utils.JavaNamingPolicy;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.runtime.MutableClassLoader;
import org.simantics.scl.compiler.runtime.RuntimeModuleMap;
import org.simantics.scl.compiler.top.ValueNotFound;

public class RuntimeModule {
    public static final boolean VALIDATE_CLASS_NAMES = true;
    public static final boolean TRACE_CLASS_CREATION = false;
    Module module;
    ModuleClassLoader classLoader;
    THashMap<String, Object> valueCache = new THashMap();
    TransientClassBuilder classBuilder;
    RuntimeModuleMap parentModuleMap;
    public Environment moduleEnvironment = new GlobalOnlyEnvironment(){

        @Override
        protected Collection<Module> getModules() {
            ArrayList<Module> result = new ArrayList<Module>(RuntimeModule.this.parentModuleMap.size() + 1);
            result.add(RuntimeModule.this.module);
            for (RuntimeModule rm : RuntimeModule.this.parentModuleMap.values()) {
                result.add(rm.module);
            }
            return result;
        }

        @Override
        protected Module getModule(String name) {
            return RuntimeModule.this.classLoader.getModule(name);
        }

        @Override
        public void collectRules(Collection<TransformationRule> rules) {
        }
    };

    public RuntimeModule(Module module, RuntimeModuleMap parentModuleMap, ClassLoader parentClassLoader) {
        if (parentClassLoader == null) {
            throw new NullPointerException();
        }
        this.module = module;
        this.parentModuleMap = parentModuleMap;
        this.classLoader = new ModuleClassLoader(parentClassLoader);
        this.classBuilder = new TransientClassBuilder(this.classLoader, new JavaTypeTranslator(this.moduleEnvironment));
    }

    public Object getValue(String name) throws ValueNotFound {
        if (this.valueCache.containsKey((Object)name)) {
            return this.valueCache.get((Object)name);
        }
        SCLValue valueConstructor = this.module.getValue(name);
        if (valueConstructor == null) {
            throw new ValueNotFound(String.valueOf(this.module.getName()) + "/" + name);
        }
        Object value = valueConstructor.realizeValue(this.getClassBuilder());
        this.valueCache.put((Object)name, value);
        return value;
    }

    private TransientClassBuilder getClassBuilder() {
        return this.classBuilder;
    }

    public Module getModule() {
        return this.module;
    }

    public MutableClassLoader getMutableClassLoader() {
        return this.classLoader;
    }

    public static String extractClassLoaderId(String className) {
        int p = className.indexOf(36, MutableClassLoader.SCL_PACKAGE_PREFIX_LENGTH);
        return JavaNamingPolicy.classNameToModuleName(p < 0 ? className.substring(MutableClassLoader.SCL_PACKAGE_PREFIX_LENGTH) : className.substring(MutableClassLoader.SCL_PACKAGE_PREFIX_LENGTH, p));
    }

    public void dispose() {
        this.module.dispose();
        this.module = null;
        this.valueCache.clear();
        this.parentModuleMap = null;
        this.classLoader = null;
        this.classBuilder = null;
    }

    class ModuleClassLoader
    extends ClassLoader
    implements MutableClassLoader {
        String moduleName;
        THashMap<String, byte[]> localClasses;
        int transientPackageId;

        public ModuleClassLoader(ClassLoader parent) {
            super(parent);
            this.localClasses = new THashMap();
            this.transientPackageId = 0;
            this.moduleName = RuntimeModule.this.module.getName();
        }

        public synchronized void addClass(String name, byte[] class_) {
            this.validateClassName(name);
            this.localClasses.put((Object)name, (Object)class_);
        }

        @Override
        public synchronized void addClasses(Map<String, byte[]> classes) {
            for (String name : classes.keySet()) {
                this.validateClassName(name);
            }
            this.localClasses.putAll(classes);
        }

        private void validateClassName(String name) {
        }

        public byte[] getBytes(String name) {
            if (!name.startsWith("scl.")) {
                return null;
            }
            String requestedModuleName = RuntimeModule.extractClassLoaderId(name);
            if (requestedModuleName.equals(this.moduleName)) {
                String internalName = name.replace('.', '/');
                byte[] bytes = RuntimeModule.this.module.getClass(internalName);
                if (bytes != null) {
                    return bytes;
                }
                return (byte[])this.localClasses.get((Object)internalName);
            }
            RuntimeModule parentModule = RuntimeModule.this.parentModuleMap.get(requestedModuleName);
            if (parentModule == null) {
                return null;
            }
            return parentModule.classLoader.getBytes(name);
        }

        synchronized Class<?> getLocalClass(String name) throws ClassNotFoundException {
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz != null) {
                return clazz;
            }
            String internalName = name.replace('.', '/');
            byte[] bytes = RuntimeModule.this.module.getClass(internalName);
            if (bytes == null && (bytes = (byte[])this.localClasses.get((Object)internalName)) == null) {
                throw new ClassNotFoundException(name);
            }
            return this.defineClass(name, bytes, 0, bytes.length);
        }

        /*
         * Unable to fully structure code
         */
        private Class<?> getClass(String name) throws ClassNotFoundException {
            if (!name.startsWith("scl.")) {
                try {
                    return this.getParent().loadClass(name);
                }
                catch (ClassNotFoundException v0) {
                    ** for (module : RuntimeModule.this.parentModuleMap.values())
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        return module.classLoader.getParent().loadClass(name);
                    }
                    catch (ClassNotFoundException v1) {}
                    continue;
                }
lbl10:
                // 1 sources

                throw new ClassNotFoundException(name);
            }
            requestedModuleName = RuntimeModule.extractClassLoaderId(name);
            if (requestedModuleName.equals(this.moduleName)) {
                return this.getLocalClass(name);
            }
            parentModule = RuntimeModule.this.parentModuleMap.get(requestedModuleName);
            if (parentModule == null) {
                System.err.println("requestedModuleName = " + requestedModuleName);
                System.err.println("this.moduleName = " + this.moduleName);
                throw new ClassNotFoundException(name);
            }
            return parentModule.classLoader.getLocalClass(name);
        }

        @Override
        public synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> clazz = this.getClass(name);
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }

        public Module getModule(String moduleName) {
            if (moduleName.equals(this.moduleName)) {
                return RuntimeModule.this.module;
            }
            RuntimeModule parentModule = RuntimeModule.this.parentModuleMap.get(moduleName);
            if (parentModule == null) {
                throw new RuntimeException("Didn't find module " + moduleName + ".");
            }
            return parentModule.module;
        }

        public String getModuleName() {
            return this.moduleName;
        }

        @Override
        public synchronized String getFreshPackageName() {
            return String.valueOf(this.moduleName) + "$" + ++this.transientPackageId;
        }

        @Override
        public THashMap<Constant, Object> getConstantCache() {
            return null;
        }

        @Override
        public ClassLoader getClassLoader() {
            return this;
        }
    }
}

