/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.module;

import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.internal.parsing.Symbol;
import org.simantics.scl.compiler.internal.parsing.declarations.DeclarationAst;

public class ImportDeclaration
extends DeclarationAst {
    public static final ImportSpec DEFAULT_SPEC = new ImportSpec(true, new EVar[0]);
    public static final ImportDeclaration[] EMPTY_ARRAY = new ImportDeclaration[0];
    public static final ImportDeclaration[] ONLY_BUILTINS = new ImportDeclaration[]{new ImportDeclaration("Builtin", "")};
    public final String moduleName;
    public final String localName;
    public final boolean reexport;
    public final ImportSpec spec;

    public ImportDeclaration(String moduleName, String localName, boolean reexport) {
        this.moduleName = moduleName;
        this.localName = localName;
        this.reexport = reexport;
        this.spec = DEFAULT_SPEC;
    }

    public ImportDeclaration(String moduleName, String localName, boolean reexport, ImportSpec spec) {
        if (spec == null) {
            throw new NullPointerException();
        }
        this.moduleName = moduleName;
        this.localName = localName;
        this.reexport = reexport;
        this.spec = spec;
    }

    public ImportDeclaration(String moduleName, String localName) {
        this(moduleName, localName, false);
    }

    @Override
    public void toString(int indentation, StringBuilder b) {
        int i = 0;
        while (i < indentation) {
            b.append("    ");
            ++i;
        }
        if (this.reexport) {
            b.append("include \"");
        } else {
            b.append("import \"");
        }
        b.append(this.moduleName);
        b.append("\" as ");
        b.append(this.localName);
    }

    public String getSpecString() {
        return this.spec.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.localName == null ? 0 : this.localName.hashCode());
        result = 31 * result + (this.moduleName == null ? 0 : this.moduleName.hashCode());
        result = 31 * result + (this.reexport ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ImportDeclaration other = (ImportDeclaration)obj;
        if (this.localName == null ? other.localName != null : !this.localName.equals(other.localName)) {
            return false;
        }
        if (this.moduleName == null ? other.moduleName != null : !this.moduleName.equals(other.moduleName)) {
            return false;
        }
        return this.reexport == other.reexport;
    }

    public static class ImportSpec
    extends Symbol {
        public final boolean hiding;
        public final EVar[] values;

        public ImportSpec(boolean hiding, EVar[] values) {
            this.hiding = hiding;
            this.values = values;
        }

        public String toString() {
            if (this.hiding && this.values.length == 0) {
                return "";
            }
            StringBuilder b = new StringBuilder();
            if (this.hiding) {
                b.append("hiding ");
            }
            b.append('(');
            int i = 0;
            while (i < this.values.length) {
                if (i > 0) {
                    b.append(',');
                }
                b.append(this.values[i].name);
                ++i;
            }
            b.append(')');
            return b.toString();
        }
    }
}

