/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.markdown.nodes;

import java.util.ArrayList;
import java.util.List;
import org.simantics.scl.compiler.markdown.internal.ExtensionNodeHandler;
import org.simantics.scl.compiler.markdown.nodes.HeaderNode;

public abstract class Node {
    public Node next;
    public Node prev;
    public Node parent;
    public Node firstChild;
    public Node lastChild;
    public boolean open = true;
    public boolean lastLineBlank = false;
    public StringBuilder stringContent;
    public int lineNumber;

    public void setLastLineBlank(boolean value) {
        this.lastLineBlank = value;
    }

    public boolean canContain(Node node) {
        return false;
    }

    public boolean acceptLines() {
        return false;
    }

    public void toHtml(StringBuilder b) {
        Node child = this.firstChild;
        while (child != null) {
            child.toHtml(b);
            child = child.next;
        }
    }

    public List<HeaderNode> extractHeaders() {
        ArrayList<HeaderNode> result = new ArrayList<HeaderNode>();
        Node child = this.firstChild;
        while (child != null) {
            if (child instanceof HeaderNode) {
                result.add((HeaderNode)child);
            }
            child = child.next;
        }
        return result;
    }

    public String toHtml() {
        StringBuilder b = new StringBuilder();
        this.toHtml(b);
        int len = b.length();
        if (len > 0 && b.charAt(len - 1) == '\n') {
            b.delete(len - 1, len);
        }
        return b.toString();
    }

    public void toPlainText(StringBuilder b) {
        Node child = this.firstChild;
        while (child != null) {
            child.toPlainText(b);
            child = child.next;
        }
    }

    public void remove() {
        if (this.prev == null) {
            this.parent.firstChild = this.next;
        } else {
            this.prev.next = this.next;
        }
        if (this.next == null) {
            this.parent.lastChild = this.prev;
        } else {
            this.next.prev = this.prev;
        }
    }

    public void processExtensionNodes(ExtensionNodeHandler handler) {
        Node child = this.firstChild;
        while (child != null) {
            child.processExtensionNodes(handler);
            child = child.next;
        }
    }

    public void addChild(Node child) {
        child.parent = this;
        if (this.lastChild == null) {
            this.firstChild = child;
        } else {
            this.lastChild.next = child;
            child.prev = this.lastChild;
        }
        this.lastChild = child;
    }
}

