/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.markdown.nodes;

import org.simantics.scl.compiler.markdown.nodes.ItemNode;
import org.simantics.scl.compiler.markdown.nodes.Node;

public class ListNode
extends Node {
    public char bulletChar;
    public boolean tight;
    public int start;

    public ListNode(char bulletChar) {
        this.bulletChar = bulletChar;
    }

    public ListNode(char bulletChar, int start) {
        this.bulletChar = bulletChar;
        this.start = start;
    }

    @Override
    public boolean canContain(Node node) {
        return node instanceof ItemNode;
    }

    public boolean isCompatible(char bulletChar) {
        return bulletChar == this.bulletChar;
    }

    @Override
    public void toHtml(StringBuilder b) {
        if (this.bulletChar == '+' || this.bulletChar == '-' || this.bulletChar == '*') {
            b.append("<ul>\n");
            Node child = this.firstChild;
            while (child != null) {
                ((ItemNode)child).toHtml(b, this.tight);
                child = child.next;
            }
            b.append("</ul>\n");
        } else {
            if (this.start == 1) {
                b.append("<ol>\n");
            } else {
                b.append("<ol start=\"").append(this.start).append("\">\n");
            }
            Node child = this.firstChild;
            while (child != null) {
                ((ItemNode)child).toHtml(b, this.tight);
                child = child.next;
            }
            b.append("</ol>\n");
        }
    }
}

