/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.markdown.nodes;

import org.simantics.scl.compiler.markdown.internal.ExtensionNodeHandler;
import org.simantics.scl.compiler.markdown.nodes.DocumentNode;
import org.simantics.scl.compiler.markdown.nodes.Node;

public class ExtensionBlockNode
extends Node {
    String extension;
    String content;

    public ExtensionBlockNode(String extension, String content) {
        this.extension = extension;
        this.content = content;
    }

    @Override
    public void processExtensionNodes(ExtensionNodeHandler handler) {
        DocumentNode replacingNodes = handler.expandBlock(this.extension, this.content);
        if (replacingNodes != null) {
            if (replacingNodes.firstChild == null) {
                this.remove();
            } else {
                Node child = replacingNodes.firstChild;
                while (child != null) {
                    child.parent = this.parent;
                    child = child.next;
                }
                if (this.prev == null) {
                    this.parent.firstChild = replacingNodes.firstChild;
                } else {
                    replacingNodes.firstChild.prev = this.prev;
                    this.prev.next = replacingNodes.firstChild;
                }
                if (this.next == null) {
                    this.parent.lastChild = replacingNodes.lastChild;
                } else {
                    replacingNodes.lastChild.next = this.next;
                    this.next.prev = replacingNodes.lastChild;
                }
            }
        }
    }

    @Override
    public void toHtml(StringBuilder b) {
        b.append("::").append(this.extension).append('[').append(this.content).append(']');
    }
}

