/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.parsing.types;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;
import java.util.Arrays;
import org.simantics.scl.compiler.elaboration.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.elaboration.modules.TypeAlias;
import org.simantics.scl.compiler.elaboration.modules.TypeDescriptor;
import org.simantics.scl.compiler.environment.AmbiguousNameException;
import org.simantics.scl.compiler.environment.Environments;
import org.simantics.scl.compiler.internal.parsing.types.TVarAst;
import org.simantics.scl.compiler.internal.parsing.types.TypeAst;
import org.simantics.scl.compiler.internal.types.TypeElaborationContext;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.KMetaVar;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class TApplyAst
extends TypeAst {
    public final TypeAst function;
    public final TypeAst[] parameters;

    public TApplyAst(TypeAst function, TypeAst[] parameters) {
        this.function = function;
        this.parameters = parameters;
    }

    @Override
    public void toString(StringBuilder b) {
        this.function.toString(b, 2);
        TypeAst[] typeAstArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            TypeAst parameter = typeAstArray[n2];
            b.append(' ');
            parameter.toString(b, 1);
            ++n2;
        }
    }

    @Override
    public Type toType(TypeTranslationContext context, Kind expectedKind) {
        if (this.function instanceof TVarAst) {
            String name = ((TVarAst)this.function).name;
            TypeAlias alias = null;
            try {
                TypeDescriptor tdesc = Environments.getTypeDescriptor(context.getEnvironment(), name);
                if (tdesc instanceof TypeAlias) {
                    alias = (TypeAlias)tdesc;
                }
            }
            catch (AmbiguousNameException e) {
                context.getErrorLog().log(this.location, e.getMessage());
                return Types.metaVar(Kinds.STAR);
            }
            if (alias != null) {
                if (this.parameters.length != alias.getArity()) {
                    context.getErrorLog().log(this.location, "Wrong number of parameters are given to the type alias. Expected " + alias.getArity() + " parameters, got " + this.parameters.length + " parameters.");
                    return Types.metaVar(Kinds.metaVar());
                }
                Type[] parameterTypes = new Type[this.parameters.length];
                int i = 0;
                while (i < this.parameters.length) {
                    parameterTypes[i] = this.parameters[i].toType(context, Kinds.metaVar());
                    ++i;
                }
                return alias.body.replace(alias.parameters, parameterTypes);
            }
        }
        Kind[] parameterKinds = new Kind[this.parameters.length];
        Kind functionKind = expectedKind;
        int i = this.parameters.length - 1;
        while (i >= 0) {
            KMetaVar kind = Kinds.metaVar();
            parameterKinds[i] = kind;
            functionKind = Kinds.arrow(kind, functionKind);
            --i;
        }
        Type functionType = this.function.toType(context, functionKind);
        Type[] parameterTypes = new Type[this.parameters.length];
        int i2 = 0;
        while (i2 < this.parameters.length) {
            parameterTypes[i2] = this.parameters[i2].toType(context, parameterKinds[i2]);
            ++i2;
        }
        return Types.apply(functionType, parameterTypes);
    }

    @Override
    public Type toType(TypeElaborationContext context) {
        Type functionType = this.function.toType(context);
        Type[] parameterTypes = new Type[this.parameters.length];
        int i = 0;
        while (i < this.parameters.length) {
            parameterTypes[i] = this.parameters[i].toType(context);
            ++i;
        }
        return Types.apply(functionType, parameterTypes);
    }

    @Override
    public int getPrecedence() {
        return 1;
    }

    public static TApplyAst apply(TypeAst f, TypeAst p) {
        if (f instanceof TApplyAst) {
            TApplyAst fApply = (TApplyAst)f;
            TypeAst[] parameters = Arrays.copyOf(fApply.parameters, fApply.parameters.length + 1);
            parameters[fApply.parameters.length] = p;
            return new TApplyAst(fApply.function, parameters);
        }
        return new TApplyAst(f, new TypeAst[]{p});
    }

    @Override
    public void collectReferences(TObjectIntHashMap<String> typeNameMap, TIntHashSet set) {
        this.function.collectReferences(typeNameMap, set);
        TypeAst[] typeAstArray = this.parameters;
        int n = this.parameters.length;
        int n2 = 0;
        while (n2 < n) {
            TypeAst parameter = typeAstArray[n2];
            parameter.collectReferences(typeNameMap, set);
            ++n2;
        }
    }
}

