/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.internal.codegen.chr;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import org.cojen.classfile.TypeDesc;
import org.objectweb.asm.Label;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.chr.plan.PrioritizedPlan;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;
import org.simantics.scl.compiler.internal.codegen.references.BoundVar;
import org.simantics.scl.compiler.internal.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.internal.codegen.utils.ClassBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.CodeBuilderUtils;
import org.simantics.scl.compiler.internal.codegen.utils.Constants;
import org.simantics.scl.compiler.internal.codegen.utils.LocalVariable;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilderBase;
import org.simantics.scl.compiler.internal.codegen.utils.ModuleBuilder;

public class CHRCodeGenerator {
    public static final TypeDesc FACT_ID_TYPE = TypeDesc.INT;
    public static final String CHRHashIndex_name = "org/simantics/scl/runtime/chr/CHRHashIndex";
    public static final TypeDesc CHRHashIndex = TypeDesc.forClass("org/simantics/scl/runtime/chr/CHRHashIndex");
    public static final String FactActivationQueue_name = "org/simantics/scl/runtime/chr/FactActivationQueue";
    public static final TypeDesc FactActivationQueue = TypeDesc.forClass("org/simantics/scl/runtime/chr/FactActivationQueue");
    public static final String Fact_name = "org/simantics/scl/runtime/chr/Fact";
    public static final TypeDesc Fact = TypeDesc.forClass("org/simantics/scl/runtime/chr/Fact");
    public static final String QUEUE = "queue";

    public static void generateStore(ModuleBuilder moduleBuilder, CHRRuleset ruleset) {
        ClassBuilder storeClassBuilder = new ClassBuilder(moduleBuilder, 1, ruleset.storeClassName, "java/lang/Object", new String[0]);
        if (ruleset.parameters == null) {
            ruleset.parameters = new BoundVar[0];
        }
        ruleset.parameterTypeDescs = moduleBuilder.getJavaTypeTranslator().getTypeDescs(ruleset.parameters);
        ArrayList<StoreInitialization> hashIndexInitializations = new ArrayList<StoreInitialization>();
        for (CHRConstraint constraint : ruleset.constraints) {
            CHRCodeGenerator.generateFact(storeClassBuilder, constraint, hashIndexInitializations);
        }
        int i = 0;
        while (i < ruleset.parameterTypeDescs.length) {
            TypeDesc typeDesc = ruleset.parameterTypeDescs[i];
            if (!typeDesc.equals(TypeDesc.VOID)) {
                storeClassBuilder.addField(17, "p" + i, typeDesc);
            }
            ++i;
        }
        storeClassBuilder.addField(1, "currentId", FACT_ID_TYPE);
        for (StoreInitialization ini : hashIndexInitializations) {
            storeClassBuilder.addField(ini.access, ini.fieldName, ini.fieldType);
        }
        storeClassBuilder.addField(17, QUEUE, FactActivationQueue);
        MethodBuilderBase mb = storeClassBuilder.addConstructor(1, ruleset.parameterTypeDescs);
        mb.loadThis();
        mb.invokeConstructor(storeClassBuilder.getSuperClassName(), Constants.EMPTY_TYPEDESC_ARRAY);
        int i2 = 0;
        while (i2 < ruleset.parameterTypeDescs.length) {
            TypeDesc typeDesc = ruleset.parameterTypeDescs[i2];
            if (!typeDesc.equals(TypeDesc.VOID)) {
                mb.loadThis();
                mb.loadLocal(mb.getParameter(i2));
                mb.storeField(ruleset.storeClassName, "p" + i2, ruleset.parameterTypeDescs[i2]);
            }
            ++i2;
        }
        mb.loadThis();
        mb.loadConstant(1);
        mb.storeField(storeClassBuilder.getClassName(), "currentId", TypeDesc.INT);
        for (StoreInitialization ini : hashIndexInitializations) {
            mb.loadThis();
            mb.newObject(ini.className);
            mb.dup();
            mb.invokeConstructor(ini.className, Constants.EMPTY_TYPEDESC_ARRAY);
            mb.storeField(ruleset.storeClassName, ini.fieldName, ini.fieldType);
        }
        mb.loadThis();
        mb.newObject(FactActivationQueue_name);
        mb.dup();
        mb.loadConstant(ruleset.priorityCount);
        mb.invokeConstructor(FactActivationQueue_name, new TypeDesc[]{TypeDesc.INT});
        mb.storeField(ruleset.storeClassName, QUEUE, FactActivationQueue);
        mb.returnVoid();
        mb.finish();
        mb = storeClassBuilder.addMethodBase(1, "activate", TypeDesc.VOID, new TypeDesc[]{TypeDesc.INT});
        mb.loadThis();
        mb.loadField(ruleset.storeClassName, QUEUE, FactActivationQueue);
        mb.loadThis();
        mb.loadLocal(mb.getParameter(0));
        mb.invokeVirtual(FactActivationQueue_name, "activate", TypeDesc.VOID, new TypeDesc[]{TypeDesc.OBJECT, TypeDesc.INT});
        mb.returnVoid();
        mb.finish();
        moduleBuilder.addClass(storeClassBuilder);
    }

    private static void generateFact(ClassBuilder storeClassBuilder, CHRConstraint constraint, ArrayList<StoreInitialization> hashIndexInitializations) {
        String linkedListPrev;
        Object mb;
        CHRRuleset ruleset = constraint.parentRuleset;
        boolean supportsRemoval = constraint.mayBeRemoved();
        ModuleBuilder moduleBuilder = storeClassBuilder.getModuleBuilder();
        JavaTypeTranslator jtt = moduleBuilder.getJavaTypeTranslator();
        TypeDesc storeTypeDesc = storeClassBuilder.getType();
        TypeDesc[] storeTypeDescArray = new TypeDesc[]{storeTypeDesc};
        String factClassName = String.valueOf(storeClassBuilder.getClassName()) + "$" + constraint.name;
        TypeDesc factTypeDesc = TypeDesc.forClass(factClassName);
        ClassBuilder factClassBuilder = new ClassBuilder(moduleBuilder, 1, factClassName, "java/lang/Object", Fact_name);
        TypeDesc[] parameterTypeDescs = jtt.toTypeDescs(constraint.parameterTypes);
        factClassBuilder.addField(1, "id", FACT_ID_TYPE);
        int i = 0;
        while (i < constraint.parameterTypes.length) {
            TypeDesc typeDesc = parameterTypeDescs[i];
            if (!typeDesc.equals(TypeDesc.VOID) && parameterTypeDescs[i] != TypeDesc.VOID) {
                factClassBuilder.addField(1, CHRCodeGenerator.fieldName(i), typeDesc);
            }
            ++i;
        }
        for (CHRConstraint.IndexInfo indexInfo : constraint.getIndices()) {
            if (supportsRemoval) {
                factClassBuilder.addField(1, String.valueOf(indexInfo.indexName) + "Prev", factTypeDesc);
            }
            factClassBuilder.addField(1, String.valueOf(indexInfo.indexName) + "Next", factTypeDesc);
            String hashIndexField = String.valueOf(constraint.name) + "$" + indexInfo.indexName;
            if (indexInfo.indexMask == 0) {
                storeClassBuilder.addField(1, hashIndexField, factTypeDesc);
                continue;
            }
            ClassBuilder hashClass = CHRCodeGenerator.generateSpecializedHashIndex(storeClassBuilder, constraint, indexInfo, factTypeDesc, factClassName);
            moduleBuilder.addClass(hashClass);
            hashIndexInitializations.add(new StoreInitialization(17, hashIndexField, CHRHashIndex, hashClass.getClassName()));
        }
        hashIndexInitializations.add(new StoreInitialization(18, String.valueOf(constraint.name) + "$temp", factTypeDesc, factClassName));
        for (CHRConstraint.IndexInfo indexInfo : constraint.getIndices()) {
            if (indexInfo.indexMask == 0) continue;
            ArrayList<TypeDesc> getParameterTypeDescs = new ArrayList<TypeDesc>(constraint.parameterTypes.length);
            int i2 = 0;
            while (i2 < constraint.parameterTypes.length) {
                if ((indexInfo.indexMask >> i2 & 1) == 1) {
                    getParameterTypeDescs.add(parameterTypeDescs[i2]);
                }
                ++i2;
            }
            mb = storeClassBuilder.addMethodBase(1, String.valueOf(constraint.name) + "$" + indexInfo.indexName, factTypeDesc, getParameterTypeDescs.toArray(new TypeDesc[getParameterTypeDescs.size()]));
            ((MethodBuilderBase)mb).loadThis();
            ((MethodBuilderBase)mb).loadField(storeClassBuilder.getClassName(), String.valueOf(constraint.name) + "$temp", factTypeDesc);
            LocalVariable tempFactVar = ((MethodBuilderBase)mb).createLocalVariable("temp", factTypeDesc);
            ((MethodBuilderBase)mb).storeLocal(tempFactVar);
            int parameterId = 0;
            int i3 = 0;
            while (i3 < constraint.parameterTypes.length) {
                if ((indexInfo.indexMask >> i3 & 1) == 1) {
                    TypeDesc typeDesc = parameterTypeDescs[i3];
                    if (!typeDesc.equals(TypeDesc.VOID)) {
                        ((MethodBuilderBase)mb).loadLocal(tempFactVar);
                        ((MethodBuilderBase)mb).loadLocal(((MethodBuilderBase)mb).getParameter(parameterId));
                        ((MethodBuilderBase)mb).storeField(factClassName, CHRCodeGenerator.fieldName(i3), typeDesc);
                    }
                    ++parameterId;
                }
                ++i3;
            }
            ((MethodBuilderBase)mb).loadThis();
            ((MethodBuilderBase)mb).loadField(storeClassBuilder.getClassName(), String.valueOf(constraint.name) + "$" + indexInfo.indexName, CHRHashIndex);
            ((MethodBuilderBase)mb).loadLocal(tempFactVar);
            ((MethodBuilderBase)mb).invokeVirtual(CHRHashIndex_name, supportsRemoval ? "getEqual" : "getEqualNoRemovals", TypeDesc.OBJECT, Constants.OBJECTS[1]);
            ((MethodBuilderBase)mb).checkCast(factTypeDesc);
            ((MethodBuilderBase)mb).returnValue(factTypeDesc);
            ((MethodBuilderBase)mb).finish();
        }
        MethodBuilderBase mb2 = factClassBuilder.addMethodBase(1, "add", TypeDesc.VOID, storeTypeDescArray);
        LocalVariable storeParameter = mb2.getParameter(0);
        for (CHRConstraint.IndexInfo indexInfo : constraint.getIndices()) {
            Label cont;
            linkedListPrev = String.valueOf(indexInfo.indexName) + "Prev";
            String linkedListNext = String.valueOf(indexInfo.indexName) + "Next";
            String storeHashIndexName = String.valueOf(constraint.name) + "$" + indexInfo.indexName;
            if (indexInfo.indexMask == 0) {
                mb2.loadThis();
                mb2.loadLocal(storeParameter);
                mb2.loadField(storeClassBuilder.getClassName(), storeHashIndexName, factTypeDesc);
                if (supportsRemoval) {
                    mb2.dupX1();
                }
                mb2.storeField(factClassName, linkedListNext, factTypeDesc);
                if (supportsRemoval) {
                    cont = new Label();
                    mb2.ifNullBranch(cont, true);
                    mb2.loadThis();
                    mb2.loadField(factClassName, linkedListNext, factTypeDesc);
                    mb2.loadThis();
                    mb2.storeField(factClassName, linkedListPrev, factTypeDesc);
                    mb2.setLocation(cont);
                }
                mb2.loadLocal(storeParameter);
                mb2.loadThis();
                mb2.storeField(storeClassBuilder.getClassName(), storeHashIndexName, factTypeDesc);
                continue;
            }
            mb2.loadThis();
            mb2.loadLocal(storeParameter);
            mb2.loadField(storeClassBuilder.getClassName(), storeHashIndexName, CHRHashIndex);
            mb2.loadThis();
            mb2.invokeVirtual(CHRHashIndex_name, supportsRemoval ? "addFreshAndReturnOld" : "addFreshAndReturnOld", TypeDesc.OBJECT, Constants.OBJECTS[1]);
            mb2.checkCast(factTypeDesc);
            if (supportsRemoval) {
                mb2.dupX1();
            }
            mb2.storeField(factClassName, linkedListNext, factTypeDesc);
            if (!supportsRemoval) continue;
            cont = new Label();
            mb2.ifNullBranch(cont, true);
            mb2.loadThis();
            mb2.loadField(factClassName, linkedListNext, factTypeDesc);
            mb2.loadThis();
            mb2.storeField(factClassName, linkedListPrev, factTypeDesc);
            mb2.setLocation(cont);
        }
        if (!constraint.isPassive()) {
            mb2.loadLocal(storeParameter);
            mb2.loadField(storeClassBuilder.getClassName(), QUEUE, FactActivationQueue);
            mb2.loadConstant(constraint.getMinimumPriority());
            mb2.loadThis();
            mb2.invokeVirtual(FactActivationQueue_name, "add", TypeDesc.VOID, new TypeDesc[]{TypeDesc.INT, Fact});
        }
        mb2.returnVoid();
        mb2.finish();
        if (supportsRemoval) {
            mb2 = factClassBuilder.addMethodBase(1, "remove", TypeDesc.VOID, storeTypeDescArray);
            storeParameter = mb2.getParameter(0);
            for (CHRConstraint.IndexInfo indexInfo : constraint.getIndices()) {
                linkedListPrev = String.valueOf(indexInfo.indexName) + "Prev";
                String linkedListNext = String.valueOf(indexInfo.indexName) + "Next";
                String storeHashIndexName = String.valueOf(constraint.name) + "$" + indexInfo.indexName;
                Label nextIndex = mb2.createLabel();
                mb2.loadThis();
                mb2.loadField(factClassName, linkedListPrev, factTypeDesc);
                Label else1 = new Label();
                mb2.ifNullBranch(else1, false);
                mb2.loadThis();
                mb2.loadField(factClassName, linkedListNext, factTypeDesc);
                Label else2 = new Label();
                mb2.ifNullBranch(else2, false);
                if (indexInfo.indexMask == 0) {
                    mb2.loadLocal(storeParameter);
                    mb2.loadNull();
                    mb2.storeField(storeClassBuilder.getClassName(), storeHashIndexName, factTypeDesc);
                } else {
                    mb2.loadLocal(storeParameter);
                    mb2.loadField(storeClassBuilder.getClassName(), storeHashIndexName, CHRHashIndex);
                    mb2.loadThis();
                    mb2.invokeVirtual(CHRHashIndex_name, "removeKnownToExistKey", TypeDesc.VOID, Constants.OBJECTS[1]);
                }
                mb2.branch(nextIndex);
                mb2.setLocation(else2);
                mb2.loadThis();
                mb2.loadField(factClassName, linkedListNext, factTypeDesc);
                mb2.loadNull();
                mb2.storeField(factClassName, linkedListPrev, factTypeDesc);
                if (indexInfo.indexMask == 0) {
                    mb2.loadLocal(storeParameter);
                    mb2.loadThis();
                    mb2.loadField(factClassName, linkedListNext, factTypeDesc);
                    mb2.storeField(storeClassBuilder.getClassName(), storeHashIndexName, factTypeDesc);
                } else {
                    mb2.loadLocal(storeParameter);
                    mb2.loadField(storeClassBuilder.getClassName(), storeHashIndexName, CHRHashIndex);
                    mb2.loadThis();
                    mb2.loadThis();
                    mb2.loadField(factClassName, linkedListNext, factTypeDesc);
                    mb2.invokeVirtual(CHRHashIndex_name, "replaceKnownToExistKey", TypeDesc.VOID, Constants.OBJECTS[2]);
                }
                mb2.branch(nextIndex);
                mb2.setLocation(else1);
                mb2.loadThis();
                mb2.loadField(factClassName, linkedListPrev, factTypeDesc);
                mb2.loadThis();
                mb2.loadField(factClassName, linkedListNext, factTypeDesc);
                mb2.storeField(factClassName, linkedListNext, factTypeDesc);
                mb2.loadThis();
                mb2.loadField(factClassName, linkedListNext, factTypeDesc);
                Label else3 = new Label();
                mb2.ifNullBranch(else3, true);
                mb2.loadThis();
                mb2.loadField(factClassName, linkedListNext, factTypeDesc);
                mb2.loadThis();
                mb2.loadField(factClassName, linkedListPrev, factTypeDesc);
                mb2.storeField(factClassName, linkedListPrev, factTypeDesc);
                mb2.setLocation(else3);
                mb2.branch(nextIndex);
                mb2.setLocation(nextIndex);
            }
            mb2.loadThis();
            mb2.loadConstant(-1);
            mb2.storeField(factClassName, "id", FACT_ID_TYPE);
            mb2.returnVoid();
            mb2.finish();
        }
        mb2 = factClassBuilder.addMethodBase(1, "isAlive", TypeDesc.BOOLEAN, Constants.EMPTY_TYPEDESC_ARRAY);
        if (supportsRemoval) {
            mb2.loadThis();
            mb2.loadField(factClassName, "id", FACT_ID_TYPE);
            Label thenBranch = mb2.createLabel();
            mb2.ifZeroComparisonBranch(thenBranch, "<");
            mb2.loadConstant(true);
            mb2.returnValue(TypeDesc.BOOLEAN);
            mb2.setLocation(thenBranch);
            mb2.loadConstant(false);
            mb2.returnValue(TypeDesc.BOOLEAN);
        } else {
            mb2.loadConstant(true);
            mb2.returnValue(TypeDesc.BOOLEAN);
        }
        mb2.finish();
        THashSet usedParameters = new THashSet();
        int i4 = 0;
        while (i4 < constraint.plans.size()) {
            PrioritizedPlan plan = constraint.plans.get(i4);
            mb = factClassBuilder.addMethod(1, "activate" + i4, TypeDesc.BOOLEAN, new TypeDesc[]{storeTypeDesc});
            LocalVariable storeVar = ((MethodBuilderBase)mb).getParameter(0);
            LocalVariable factVar = new LocalVariable(0, factTypeDesc);
            ((MethodBuilder)mb).setLocalVariable(ruleset.this_, storeVar);
            ((MethodBuilder)mb).setLocalVariable(plan.implementation.getParameters()[0], factVar);
            usedParameters.clear();
            plan.implementation.forValRefs(valRef -> {
                if (valRef.getBinding() instanceof BoundVar) {
                    usedParameters.add((Object)((BoundVar)valRef.getBinding()));
                }
            });
            int j = 0;
            while (j < ruleset.parameters.length) {
                BoundVar parameter = ruleset.parameters[j];
                if (usedParameters.contains((Object)parameter)) {
                    ((MethodBuilderBase)mb).loadLocal(storeVar);
                    ((MethodBuilderBase)mb).loadField(storeClassBuilder.getClassName(), "p" + j, ruleset.parameterTypeDescs[j]);
                    ((MethodBuilder)mb).store(parameter);
                }
                ++j;
            }
            plan.implementation.markGenerateOnFly();
            plan.implementation.generateCodeWithAlreadyPreparedParameters((MethodBuilder)mb);
            ((MethodBuilderBase)mb).finish();
            ++i4;
        }
        MethodBuilderBase mb3 = factClassBuilder.addMethodBase(1, "activate", TypeDesc.INT, new TypeDesc[]{TypeDesc.OBJECT, TypeDesc.INT});
        Label defaultLabel = mb3.createLabel();
        if (!constraint.isPassive()) {
            mb3.loadThis();
            mb3.loadField(factClassName, "id", TypeDesc.INT);
            mb3.ifZeroComparisonBranch(defaultLabel, "<");
            mb3.loadLocal(mb3.getParameter(0));
            mb3.checkCast(storeTypeDesc);
            LocalVariable storeVariable = new LocalVariable(1, storeTypeDesc);
            mb3.storeLocal(storeVariable);
            TIntArrayList priorities = new TIntArrayList(constraint.plans.size());
            ArrayList<Label> labels = new ArrayList<Label>();
            int lastPriority = -1;
            for (PrioritizedPlan plan : constraint.plans) {
                if (plan.priority == lastPriority) continue;
                priorities.add(plan.priority);
                labels.add(mb3.createLabel());
                lastPriority = plan.priority;
            }
            mb3.loadLocal(mb3.getParameter(1));
            mb3.switch_(priorities.toArray(), labels.toArray(new Label[labels.size()]), defaultLabel);
            int labelId = -1;
            int i5 = 0;
            while (i5 < constraint.plans.size()) {
                PrioritizedPlan plan = constraint.plans.get(i5);
                if (labelId == -1 || plan.priority != priorities.get(labelId)) {
                    if (labelId >= 0) {
                        mb3.loadConstant(plan.priority);
                        mb3.returnValue(TypeDesc.INT);
                    }
                    mb3.setLocation((Label)labels.get(++labelId));
                }
                mb3.loadThis();
                mb3.loadLocal(storeVariable);
                mb3.invokeVirtual(factClassName, "activate" + i5, TypeDesc.BOOLEAN, new TypeDesc[]{storeTypeDesc});
                mb3.ifZeroComparisonBranch(defaultLabel, "==");
                ++i5;
            }
            mb3.setLocation(defaultLabel);
        }
        mb3.loadConstant(-1);
        mb3.returnValue(TypeDesc.INT);
        mb3.finish();
        ArrayList<TypeDesc> constructorParameters = new ArrayList<TypeDesc>(parameterTypeDescs.length + 1);
        constructorParameters.add(FACT_ID_TYPE);
        TypeDesc[] labels = parameterTypeDescs;
        int priorities = parameterTypeDescs.length;
        int storeVariable = 0;
        while (storeVariable < priorities) {
            TypeDesc typeDesc = labels[storeVariable];
            if (!typeDesc.equals(TypeDesc.VOID)) {
                constructorParameters.add(typeDesc);
            }
            ++storeVariable;
        }
        MethodBuilderBase mb4 = factClassBuilder.addConstructor(1, constructorParameters.toArray(new TypeDesc[constructorParameters.size()]));
        mb4.loadThis();
        mb4.invokeConstructor(factClassBuilder.getSuperClassName(), Constants.EMPTY_TYPEDESC_ARRAY);
        mb4.loadThis();
        mb4.loadLocal(mb4.getParameter(0));
        mb4.storeField(factClassName, "id", FACT_ID_TYPE);
        int i6 = 0;
        int parameterId = 1;
        while (i6 < constraint.parameterTypes.length) {
            TypeDesc typeDesc = parameterTypeDescs[i6];
            if (!typeDesc.equals(TypeDesc.VOID)) {
                mb4.loadThis();
                mb4.loadLocal(mb4.getParameter(parameterId++));
                mb4.storeField(factClassName, CHRCodeGenerator.fieldName(i6), typeDesc);
            }
            ++i6;
        }
        mb4.returnVoid();
        mb4.finish();
        factClassBuilder.addDefaultConstructor();
        moduleBuilder.addClass(factClassBuilder);
    }

    private static ClassBuilder generateSpecializedHashIndex(ClassBuilder storeClassBuilder, CHRConstraint constraint, CHRConstraint.IndexInfo indexInfo, TypeDesc factClassTypeDesc, String factClassName) {
        ModuleBuilder moduleBuilder = storeClassBuilder.getModuleBuilder();
        JavaTypeTranslator jtt = moduleBuilder.getJavaTypeTranslator();
        String hashIndexClassName = String.valueOf(factClassName) + "$" + indexInfo.indexName;
        ClassBuilder hashIndexClassBuilder = new ClassBuilder(moduleBuilder, 1, hashIndexClassName, CHRHashIndex_name, new String[0]);
        MethodBuilderBase mb = hashIndexClassBuilder.addMethodBase(4, "keyEquals", TypeDesc.BOOLEAN, Constants.OBJECTS[2]);
        mb.loadLocal(mb.getParameter(0));
        mb.checkCast(factClassTypeDesc);
        LocalVariable aVar = mb.createLocalVariable("a", factClassTypeDesc);
        mb.storeLocal(aVar);
        mb.loadLocal(mb.getParameter(1));
        mb.checkCast(factClassTypeDesc);
        LocalVariable bVar = mb.createLocalVariable("b", factClassTypeDesc);
        mb.storeLocal(bVar);
        Label failure = mb.createLabel();
        int curMask = indexInfo.indexMask;
        int i = 0;
        while (i < constraint.parameterTypes.length) {
            TypeDesc fieldTypeDesc;
            if ((curMask & 1) == 1 && !(fieldTypeDesc = jtt.toTypeDesc(constraint.parameterTypes[i])).equals(TypeDesc.VOID)) {
                mb.loadLocal(aVar);
                mb.loadField(factClassName, CHRCodeGenerator.fieldName(i), fieldTypeDesc);
                mb.loadLocal(bVar);
                mb.loadField(factClassName, CHRCodeGenerator.fieldName(i), fieldTypeDesc);
                CodeBuilderUtils.equals(mb, fieldTypeDesc, failure);
            }
            ++i;
            curMask >>= 1;
        }
        mb.loadConstant(true);
        mb.returnValue(TypeDesc.BOOLEAN);
        mb.setLocation(failure);
        mb.loadConstant(false);
        mb.returnValue(TypeDesc.BOOLEAN);
        mb.finish();
        mb = hashIndexClassBuilder.addMethodBase(4, "keyHashCode", TypeDesc.INT, Constants.OBJECTS[1]);
        mb.loadLocal(mb.getParameter(0));
        mb.checkCast(factClassTypeDesc);
        LocalVariable factVar = mb.createLocalVariable("fact", factClassTypeDesc);
        mb.storeLocal(factVar);
        mb.loadConstant(-2128831035);
        int curMask2 = indexInfo.indexMask;
        int i2 = 0;
        while (i2 < constraint.parameterTypes.length) {
            TypeDesc fieldTypeDesc;
            if ((curMask2 & 1) == 1 && !(fieldTypeDesc = jtt.toTypeDesc(constraint.parameterTypes[i2])).equals(TypeDesc.VOID)) {
                mb.loadLocal(factVar);
                mb.loadField(factClassName, CHRCodeGenerator.fieldName(i2), fieldTypeDesc);
                CodeBuilderUtils.hashCode(mb, fieldTypeDesc);
                mb.math(130);
                mb.loadConstant(16777619);
                mb.math(104);
            }
            ++i2;
            curMask2 >>= 1;
        }
        mb.returnValue(TypeDesc.INT);
        mb.finish();
        hashIndexClassBuilder.addDefaultConstructor();
        return hashIndexClassBuilder;
    }

    public static String fieldName(int id) {
        return "c" + id;
    }

    private static class StoreInitialization {
        final int access;
        final String fieldName;
        final TypeDesc fieldType;
        final String className;

        public StoreInitialization(int access, String fieldName, TypeDesc fieldType, String className) {
            this.access = access;
            this.fieldName = fieldName;
            this.fieldType = fieldType;
            this.className = className;
        }
    }
}

