/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.environment;

import java.util.ArrayList;
import java.util.Arrays;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.EnvironmentFactory;
import org.simantics.scl.compiler.module.ConcreteModule;
import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.compiler.module.repository.ImportFailureException;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.module.repository.UpdateListener;

public class EnvironmentFactoryImpl
implements EnvironmentFactory {
    private final ModuleRepository environment;
    private final ImportDeclaration[] builtinImports;
    private final UpdateListener listener;

    public EnvironmentFactoryImpl(ModuleRepository environment, ImportDeclaration[] builtinImports, UpdateListener listener) {
        this.environment = environment;
        this.builtinImports = builtinImports;
        this.listener = listener;
    }

    @Override
    public Environment createEnvironment(ImportDeclaration[] imports) throws ImportFailureException {
        ArrayList<ImportDeclaration> acceptedBuiltinImports = new ArrayList<ImportDeclaration>(this.builtinImports.length);
        ImportDeclaration[] importDeclarationArray = this.builtinImports;
        int n = this.builtinImports.length;
        int n2 = 0;
        while (n2 < n) {
            block3: {
                ImportDeclaration builtinImport = importDeclarationArray[n2];
                ImportDeclaration[] importDeclarationArray2 = imports;
                int n3 = imports.length;
                int n4 = 0;
                while (n4 < n3) {
                    ImportDeclaration decl = importDeclarationArray2[n4];
                    if (!decl.moduleName.equals(builtinImport.moduleName) || !decl.localName.equals(builtinImport.localName)) {
                        ++n4;
                        continue;
                    }
                    break block3;
                }
                acceptedBuiltinImports.add(builtinImport);
            }
            ++n2;
        }
        ImportDeclaration[] is = Arrays.copyOf(acceptedBuiltinImports.toArray(new ImportDeclaration[acceptedBuiltinImports.size()]), acceptedBuiltinImports.size() + imports.length);
        System.arraycopy(imports, 0, is, acceptedBuiltinImports.size(), imports.length);
        return this.environment.createEnvironment(is, this.listener);
    }

    @Override
    public void addBuiltinDependencies(ConcreteModule module) {
        ImportDeclaration[] importDeclarationArray = this.builtinImports;
        int n = this.builtinImports.length;
        int n2 = 0;
        while (n2 < n) {
            ImportDeclaration decl = importDeclarationArray[n2];
            ImportDeclaration decl2 = new ImportDeclaration(decl.moduleName, null);
            module.addDependency(decl2);
            ++n2;
        }
    }
}

