/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.java;

import org.cojen.classfile.TypeDesc;
import org.osgi.service.component.annotations.Component;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.constants.JavaMethod;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EExternalConstant;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.macros.MacroRule;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.internal.codegen.types.StandardTypeConstructor;
import org.simantics.scl.compiler.module.ConcreteModule;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TFun;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class LoggingModule
extends ConcreteModule {
    private static String[] LOGGING_METHODS = new String[]{"trace", "debug", "info", "warn", "error"};

    public LoggingModule() {
        super("Logging");
        final TCon Logger2 = Types.con(this.getName(), "Logger");
        StandardTypeConstructor loggerConstructor = new StandardTypeConstructor(Logger2, Kinds.STAR, TypeDesc.forClass(Logger.class));
        loggerConstructor.external = true;
        this.addTypeDescriptor("Logger", loggerConstructor);
        TFun loggingType = Types.functionE(Types.STRING, (Type)Types.PROC, (Type)Types.UNIT);
        String[] stringArray = LOGGING_METHODS;
        int n = LOGGING_METHODS.length;
        int n2 = 0;
        while (n2 < n) {
            String methodName = stringArray[n2];
            final JavaMethod javaMethod = new JavaMethod(false, "org/slf4j/Logger", methodName, (Type)Types.PROC, (Type)Types.UNIT, Logger2, Types.STRING);
            SCLValue value = new SCLValue(Name.create(this.getName(), methodName));
            value.setType(loggingType);
            value.setMacroRule(new MacroRule(){

                @Override
                public Expression apply(SimplificationContext context, Type[] typeParameters, EApply apply) {
                    ConcreteModule module = context.getCompilationContext().module;
                    apply.set(new ELiteral(javaMethod), new Expression[]{new EExternalConstant(LoggerFactory.getLogger((String)module.getName().replaceAll("/", ".")), Logger2), apply.parameters[0]});
                    return apply;
                }
            });
            this.addValue(value);
            ++n2;
        }
        this.setParentClassLoader(LoggerFactory.class.getClassLoader());
    }
}

