/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.java;

import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationContext;
import org.simantics.scl.compiler.elaboration.relations.AbstractRelation;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class EqRelation
extends AbstractRelation {
    public static final EqRelation INSTANCE = new EqRelation();
    private static final TVar A = Types.var(Kinds.STAR);
    private static final TVar[] TYPE_VARIABLES = new TVar[]{A};
    private static final Type[] PARAMETER_TYPES = new Type[]{A, A};

    private EqRelation() {
    }

    @Override
    public TVar[] getTypeVariables() {
        return TYPE_VARIABLES;
    }

    @Override
    public Type[] getParameterTypes() {
        return PARAMETER_TYPES;
    }

    @Override
    public int getPhase() {
        return 0;
    }

    @Override
    public double getSelectivity(int boundVariables) {
        switch (boundVariables) {
            case 0: {
                return Double.POSITIVE_INFINITY;
            }
            case 1: 
            case 2: {
                return 1.0;
            }
            case 3: {
                return 0.1;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public int getRequiredVariablesMask() {
        return 0;
    }

    @Override
    public void generate(long location, QueryCompilationContext context, Type[] typeParameters, Variable[] parameters, int boundVariables) {
        switch (boundVariables) {
            case 1: {
                context.let(parameters[1], new EVariable(parameters[0]));
                break;
            }
            case 2: {
                context.let(parameters[0], new EVariable(parameters[1]));
                break;
            }
            case 3: {
                context.equalityCondition(location, new EVariable(parameters[0]), new EVariable(parameters[1]));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public String toString() {
        return "=";
    }
}

