/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.SimplifiableExpression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.elaboration.query.QExists;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationContext;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationMode;
import org.simantics.scl.compiler.elaboration.query.compilation.UnsolvableQueryException;
import org.simantics.scl.compiler.internal.elaboration.utils.ExpressionDecorator;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.exceptions.UnificationException;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class EWhen
extends SimplifiableExpression {
    public Query query;
    public Expression action;
    Variable[] variables;

    public EWhen(Query query, Expression action) {
        this.query = query;
        this.action = action;
    }

    public EWhen(long location, Query query, Expression action, Variable[] variables) {
        if (variables == null) {
            throw new NullPointerException();
        }
        if (location == 9223372034707292160L) {
            new Exception().printStackTrace();
        }
        this.location = location;
        this.query = query;
        this.action = action;
        this.variables = variables;
    }

    @Override
    public void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
        this.query.collectRefs(allRefs, refs);
        this.action.collectRefs(allRefs, refs);
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        this.query.collectVars(allVars, vars);
        this.action.collectVars(allVars, vars);
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
        throw new InternalCompilerError(this.location, String.valueOf(this.getClass().getSimpleName()) + " does not support collectEffects.");
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(Types.UNIT);
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        try {
            Types.unify(requiredType, Types.UNIT);
        }
        catch (UnificationException unificationException) {
            context.typeError(this.location, requiredType, Types.UNIT);
            return this;
        }
        Variable[] variableArray = this.variables;
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable variable = variableArray[n2];
            variable.setType(Types.metaVar(Kinds.STAR));
            ++n2;
        }
        this.query.checkType(context);
        this.action.checkIgnoredType(context);
        return this.compile(context);
    }

    public Expression compile(TypingContext context) {
        try {
            QueryCompilationContext queryCompilationContext = new QueryCompilationContext(context, QueryCompilationMode.ITERATE, null, this.action);
            new QExists(this.variables, this.query).generate(queryCompilationContext);
            return queryCompilationContext.getContinuation();
        }
        catch (UnsolvableQueryException e) {
            context.getErrorLog().log(this.getLocation(), "Failed to compile the query.\n" + e.getMessage());
            return new EError(this.getLocation());
        }
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        this.action.collectFreeVariables(vars);
        this.query.collectFreeVariables(vars);
        Variable[] variableArray = this.variables;
        int n = this.variables.length;
        int n2 = 0;
        while (n2 < n) {
            Variable var = variableArray[n2];
            vars.remove((Object)var);
            ++n2;
        }
    }

    @Override
    public Expression resolve(TranslationContext context) {
        context.pushExistentialFrame();
        this.query = this.query.resolve(context);
        this.action = this.action.resolve(context);
        this.variables = context.popExistentialFrame();
        return this;
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        return decorator.decorate(this);
    }

    @Override
    public Expression replace(ReplaceContext context) {
        Variable[] newVariables = new Variable[this.variables.length];
        int i = 0;
        while (i < this.variables.length) {
            Variable newVariable;
            Variable variable = this.variables[i];
            newVariables[i] = newVariable = new Variable(variable.name, variable.getType());
            context.varMap.put((Object)variable, (Object)new EVariable(newVariable));
            ++i;
        }
        EWhen result = new EWhen(this.location, this.query.replace(context), this.action.replace(context), newVariables);
        int i2 = 0;
        while (i2 < this.variables.length) {
            context.varMap.remove((Object)this.variables[i2]);
            ++i2;
        }
        return result;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.query.setLocationDeep(loc);
            this.action.setLocationDeep(loc);
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public Query getQuery() {
        return this.query;
    }

    public Expression getAction() {
        return this.action;
    }

    @Override
    public void forVariables(VariableProcedure procedure) {
        this.query.forVariables(procedure);
        this.action.forVariables(procedure);
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }
}

