/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.elaboration.utils.ExpressionDecorator;
import org.simantics.scl.compiler.internal.interpreted.IExpression;
import org.simantics.scl.compiler.internal.interpreted.ILet;
import org.simantics.scl.compiler.internal.interpreted.ISeq;
import org.simantics.scl.compiler.top.ExpressionInterpretationContext;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public class ESimpleLet
extends Expression {
    Variable variable;
    Expression value;
    Expression in;

    public ESimpleLet(Variable variable, Expression value, Expression in) {
        if (value == null) {
            throw new NullPointerException();
        }
        if (in == null) {
            throw new NullPointerException();
        }
        this.variable = variable;
        this.value = value;
        this.in = in;
    }

    public ESimpleLet(long loc, Variable variable, Expression value, Expression in) {
        super(loc);
        if (value == null) {
            throw new NullPointerException();
        }
        if (in == null) {
            throw new NullPointerException();
        }
        this.variable = variable;
        this.value = value;
        this.in = in;
    }

    @Override
    public void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
        this.value.collectRefs(allRefs, refs);
        this.in.collectRefs(allRefs, refs);
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        this.value.collectVars(allVars, vars);
        this.in.collectVars(allVars, vars);
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(this.in.getType());
    }

    @Override
    public IVal toVal(Environment env, CodeWriter w) {
        IVal valueVal = this.value.toVal(env, w);
        if (this.variable != null) {
            this.variable.setVal(valueVal);
        }
        return this.in.toVal(env, w);
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        this.value.collectFreeVariables(vars);
        this.in.collectFreeVariables(vars);
        vars.remove((Object)this.variable);
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        this.value = this.value.simplify(context);
        if (this.value instanceof EConstant || this.value instanceof ELiteral) {
            context.addInlinedVariable(this.variable, this.value);
            return this.in.simplify(context);
        }
        this.in = this.in.simplify(context);
        return this;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        this.value = this.value.resolve(context);
        this.in = this.in.resolve(context);
        return this;
    }

    @Override
    public Expression replace(ReplaceContext context) {
        if (this.variable == null) {
            return new ESimpleLet(this.location, null, this.value.replace(context), this.in.replace(context));
        }
        Variable newVariable = this.variable.copy();
        context.varMap.put((Object)this.variable, (Object)new EVariable(newVariable));
        ESimpleLet result = new ESimpleLet(this.location, newVariable, this.value.replace(context), this.in.replace(context));
        context.varMap.remove((Object)this.variable);
        return result;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.value.setLocationDeep(loc);
            this.in.setLocationDeep(loc);
        }
    }

    @Override
    public IExpression toIExpression(ExpressionInterpretationContext context) {
        if (this.variable == null) {
            IExpression valueI = this.value.toIExpression(context);
            IExpression inI = this.in.toIExpression(context);
            return new ISeq(valueI, inI);
        }
        IExpression valueI = this.value.toIExpression(context);
        int variableId = context.push(this.variable);
        IExpression inI = this.in.toIExpression(context);
        context.pop(this.variable);
        return new ILet(variableId, valueI, inI);
    }

    private void checkBinding(TypingContext context) {
        if (this.variable == null) {
            this.value = this.value.checkIgnoredType(context);
        } else if (this.variable.getType() == null) {
            this.value = this.value.inferType(context);
            this.variable.setType(this.value.getType());
        } else {
            this.value = this.value.checkType(context, this.variable.type);
        }
    }

    @Override
    public Expression inferType(TypingContext context) {
        this.checkBinding(context);
        this.in = this.in.inferType(context);
        return this;
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        this.checkBinding(context);
        this.in = this.in.checkType(context, requiredType);
        return this;
    }

    @Override
    public Expression checkIgnoredType(TypingContext context) {
        this.checkBinding(context);
        this.in = this.in.checkIgnoredType(context);
        return this;
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        this.value = this.value.decorate(decorator);
        this.in = this.in.decorate(decorator);
        return decorator.decorate(this);
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
        this.value.collectEffects(effects);
        this.in.collectEffects(effects);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public Expression getValue() {
        return this.value;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public Expression getIn() {
        return this.in;
    }

    @Override
    public void forVariables(VariableProcedure procedure) {
        this.value.forVariables(procedure);
        this.in.forVariables(procedure);
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public int getSyntacticFunctionArity() {
        return this.in.getSyntacticFunctionArity();
    }
}

