/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EApplyType;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.SimplifiableExpression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.elaboration.java.Builtins;
import org.simantics.scl.compiler.elaboration.java.ListConstructor;
import org.simantics.scl.compiler.internal.elaboration.utils.ExpressionDecorator;
import org.simantics.scl.compiler.internal.interpreted.IExpression;
import org.simantics.scl.compiler.internal.interpreted.IListLiteral;
import org.simantics.scl.compiler.top.ExpressionInterpretationContext;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public class EListLiteral
extends SimplifiableExpression {
    Expression[] components;
    Type componentType;

    public EListLiteral(Expression[] components) {
        this.components = components;
    }

    private EListLiteral(Expression[] components, Type componentType) {
        this.components = components;
        this.componentType = componentType;
    }

    public Expression[] getComponents() {
        return this.components;
    }

    @Override
    public void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
        Expression[] expressionArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            Expression component = expressionArray[n2];
            component.collectRefs(allRefs, refs);
            ++n2;
        }
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        Expression[] expressionArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            Expression component = expressionArray[n2];
            component.collectVars(allVars, vars);
            ++n2;
        }
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        Expression[] expressionArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            Expression component = expressionArray[n2];
            component.collectFreeVariables(vars);
            ++n2;
        }
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        context.pushLocation(this.location);
        try {
            int i = 0;
            while (i < this.components.length) {
                this.components[i] = this.components[i].simplify(context);
                ++i;
            }
            if (this.components.length <= 32) {
                Expression result = new EConstant(this.location, Builtins.LIST_CONSTRUCTORS[this.components.length], this.componentType);
                if (this.components.length > 0) {
                    result = new EApply(this.location, result, this.components);
                }
                EConstant eConstant = result;
                return eConstant;
            }
            Expression result = new EApplyType(new ELiteral(this.location, new ListConstructor(this.components.length)), this.componentType);
            Expression expression = result = new EApply(this.location, result, this.components);
            return expression;
        }
        finally {
            context.popLocation();
        }
    }

    @Override
    public Expression resolve(TranslationContext context) {
        int i = 0;
        while (i < this.components.length) {
            this.components[i] = this.components[i].resolve(context);
            ++i;
        }
        return this;
    }

    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        int i = 0;
        while (i < this.components.length) {
            this.components[i] = this.components[i].resolveAsPattern(context);
            ++i;
        }
        return this;
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(Types.list(this.componentType));
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        try {
            this.componentType = Types.unifyApply(Types.LIST, requiredType);
        }
        catch (MatchException matchException) {
            context.getErrorLog().log(this.location, "Expected a value with type " + requiredType + " but got a list.");
            return new EError(this.location);
        }
        int i = 0;
        while (i < this.components.length) {
            this.components[i] = this.components[i].checkType(context, this.componentType);
            ++i;
        }
        return this;
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        int i = 0;
        while (i < this.components.length) {
            this.components[i] = this.components[i].decorate(decorator);
            ++i;
        }
        return decorator.decorate(this);
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
        Expression[] expressionArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            Expression component = expressionArray[n2];
            component.collectEffects(effects);
            ++n2;
        }
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            Expression[] expressionArray = this.components;
            int n = this.components.length;
            int n2 = 0;
            while (n2 < n) {
                Expression component = expressionArray[n2];
                component.setLocationDeep(loc);
                ++n2;
            }
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public IExpression toIExpression(ExpressionInterpretationContext target) {
        IExpression[] componentExpressions = new IExpression[this.components.length];
        int i = 0;
        while (i < this.components.length) {
            componentExpressions[i] = this.components[i].toIExpression(target);
            ++i;
        }
        return new IListLiteral(componentExpressions);
    }

    @Override
    public void forVariables(VariableProcedure procedure) {
        Expression[] expressionArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            Expression component = expressionArray[n2];
            component.forVariables(procedure);
            ++n2;
        }
    }

    @Override
    public Expression replace(ReplaceContext context) {
        Expression[] newComponents = new Expression[this.components.length];
        int i = 0;
        while (i < this.components.length) {
            newComponents[i] = this.components[i].replace(context);
            ++i;
        }
        return new EListLiteral(newComponents, this.componentType.replace(context.tvarMap));
    }

    @Override
    public boolean isPattern(int arity) {
        if (arity != 0) {
            return false;
        }
        Expression[] expressionArray = this.components;
        int n = this.components.length;
        int n2 = 0;
        while (n2 < n) {
            Expression component = expressionArray[n2];
            if (!component.isPattern(0)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }
}

