/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.elaboration.utils.ExpressionDecorator;
import org.simantics.scl.compiler.internal.interpreted.IConstant;
import org.simantics.scl.compiler.internal.interpreted.IExpression;
import org.simantics.scl.compiler.internal.interpreted.IIf;
import org.simantics.scl.compiler.top.ExpressionInterpretationContext;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.runtime.tuple.Tuple0;

public class EIf
extends Expression {
    public Expression condition;
    public Expression then_;
    public Expression else_;

    public EIf(Expression condition, Expression then_, Expression else_) {
        this.condition = condition;
        this.then_ = then_;
        this.else_ = else_;
    }

    public EIf(long loc, Expression condition, Expression then_, Expression else_) {
        super(loc);
        this.condition = condition;
        this.then_ = then_;
        this.else_ = else_;
    }

    @Override
    public void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
        this.condition.collectRefs(allRefs, refs);
        this.then_.collectRefs(allRefs, refs);
        if (this.else_ != null) {
            this.else_.collectRefs(allRefs, refs);
        }
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        this.condition.collectVars(allVars, vars);
        this.then_.collectVars(allVars, vars);
        if (this.else_ != null) {
            this.else_.collectVars(allVars, vars);
        }
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(this.then_.getType());
    }

    @Override
    public IVal toVal(Environment env, CodeWriter w) {
        IVal conditionVal = this.condition.toVal(env, w);
        CodeWriter joinPoint = w.createBlock(this.getType());
        CodeWriter thenBlock = w.createBlock();
        if (this.else_ != null) {
            CodeWriter elseBlock = w.createBlock();
            w.if_(conditionVal, thenBlock.getContinuation(), elseBlock.getContinuation());
            IVal elseVal = this.else_.toVal(env, elseBlock);
            elseBlock.jump(joinPoint.getContinuation(), elseVal);
        } else {
            w.if_(conditionVal, thenBlock.getContinuation(), joinPoint.getContinuation());
        }
        IVal thenVal = this.then_.toVal(env, thenBlock);
        thenBlock.jump(joinPoint.getContinuation(), thenVal);
        w.continueAs(joinPoint);
        return w.getParameters()[0];
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        this.condition.collectFreeVariables(vars);
        this.then_.collectFreeVariables(vars);
        if (this.else_ != null) {
            this.else_.collectFreeVariables(vars);
        }
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        this.condition = this.condition.simplify(context);
        this.then_ = this.then_.simplify(context);
        if (this.else_ != null) {
            this.else_ = this.else_.simplify(context);
        }
        return this;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        this.condition = this.condition.resolve(context);
        this.then_ = this.then_.resolve(context);
        if (this.else_ != null) {
            this.else_ = this.else_.resolve(context);
        }
        return this;
    }

    @Override
    public Expression replace(ReplaceContext context) {
        return new EIf(this.condition.replace(context), this.then_.replace(context), this.else_ == null ? null : this.else_.replace(context));
    }

    @Override
    public Expression checkBasicType(TypingContext context, Type requiredType) {
        this.condition = this.condition.checkType(context, Types.BOOLEAN);
        this.then_ = this.then_.checkType(context, requiredType);
        if (this.else_ != null) {
            this.else_ = this.else_.checkType(context, requiredType);
        } else {
            context.getErrorLog().log(this.location, "Else branch is required because the return value of the if expression is used.");
        }
        return this;
    }

    @Override
    public Expression checkIgnoredType(TypingContext context) {
        this.condition = this.condition.checkType(context, Types.BOOLEAN);
        this.then_ = this.then_.checkIgnoredType(context);
        if (this.else_ != null) {
            this.else_ = this.else_.checkIgnoredType(context);
        }
        return this;
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        this.condition = this.condition.decorate(decorator);
        this.then_ = this.then_.decorate(decorator);
        if (this.else_ != null) {
            this.else_ = this.else_.decorate(decorator);
        }
        return decorator.decorate(this);
    }

    @Override
    public boolean isEffectful() {
        return this.condition.isEffectful() || this.then_.isEffectful() || this.else_ != null && this.else_.isEffectful();
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
        this.condition.collectEffects(effects);
        this.then_.collectEffects(effects);
        if (this.else_ != null) {
            this.else_.collectEffects(effects);
        }
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.condition.setLocationDeep(loc);
            this.then_.setLocationDeep(loc);
            if (this.else_ != null) {
                this.else_.setLocationDeep(loc);
            }
        }
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public IExpression toIExpression(ExpressionInterpretationContext target) {
        return new IIf(this.condition.toIExpression(target), this.then_.toIExpression(target), this.else_ != null ? this.else_.toIExpression(target) : new IConstant(Tuple0.INSTANCE));
    }

    @Override
    public void forVariables(VariableProcedure procedure) {
        this.condition.forVariables(procedure);
        this.then_.forVariables(procedure);
        if (this.else_ != null) {
            this.else_.forVariables(procedure);
        }
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public int getSyntacticFunctionArity() {
        return Math.max(this.then_.getSyntacticFunctionArity(), this.else_.getSyntacticFunctionArity());
    }
}

