/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.THashMap;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.expressions.ASTExpression;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.Expressions;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.java.EqRelation;
import org.simantics.scl.compiler.elaboration.query.QAtom;
import org.simantics.scl.compiler.elaboration.query.Query;
import org.simantics.scl.compiler.elaboration.relations.SCLEntityType;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.environment.AmbiguousNameException;
import org.simantics.scl.compiler.environment.Environments;
import org.simantics.scl.compiler.internal.parsing.Token;

public class EEntityTypeAnnotation
extends ASTExpression {
    Expression expression;
    Token entityTypeName;
    SCLEntityType entityType;
    Query query;
    THashMap<String, SCLEntityType.AttributeBinding> attributeBindingMap;

    public EEntityTypeAnnotation(Expression expression, Token entityTypeName, Query query) {
        this.expression = expression;
        this.entityTypeName = entityTypeName;
        this.query = query;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        Variable base;
        this.expression = this.expression.resolve(context);
        if (context.currentPreQuery == null) {
            context.getErrorLog().log(this.location, "Entity type annotations can be used only in queries.");
            return new EError(this.location);
        }
        try {
            this.entityType = Environments.getEntityType(context.getEnvironment(), this.entityTypeName.text);
        }
        catch (AmbiguousNameException e) {
            context.getErrorLog().log(this.location, e.getMessage());
            return new EError(this.location);
        }
        if (this.entityType == null) {
            context.getErrorLog().log(this.location, "Couldn't resolve entity type " + this.entityTypeName.text + ".");
            return new EError(this.location);
        }
        if (this.expression instanceof EVariable) {
            base = ((EVariable)this.expression).variable;
        } else {
            base = new Variable("?" + this.entityTypeName.text);
            context.currentPreQuery.extraVariables.add(base);
            context.currentPreQuery.sideQueries.add(Expressions.loc(this.expression.location, new QAtom((SCLRelation)EqRelation.INSTANCE, new EVariable(base), this.expression)));
            this.expression = Expressions.loc(this.expression.location, new EVariable(base));
        }
        if (this.query != null) {
            SCLEntityType.AttributeBinding[] attributeBindings;
            EEntityTypeAnnotation oldEntityTypeAnnotation = context.currentEntityTypeAnnotation;
            this.attributeBindingMap = new THashMap();
            context.currentEntityTypeAnnotation = this;
            this.query = this.query.resolve(context);
            context.currentPreQuery.sideQueries.add(this.query);
            context.currentEntityTypeAnnotation = oldEntityTypeAnnotation;
            if (this.attributeBindingMap.isEmpty()) {
                attributeBindings = SCLEntityType.AttributeBinding.EMPTY_ARRAY;
            } else {
                SCLEntityType.AttributeBinding[] attributeBindingArray = attributeBindings = this.attributeBindingMap.values().toArray(new SCLEntityType.AttributeBinding[this.attributeBindingMap.size()]);
                int n = attributeBindings.length;
                int n2 = 0;
                while (n2 < n) {
                    SCLEntityType.AttributeBinding binding = attributeBindingArray[n2];
                    context.currentPreQuery.extraVariables.add(binding.variable);
                    ++n2;
                }
            }
            context.currentPreQuery.sideQueries.add(this.entityType.generateQuery(context, base, attributeBindings));
        } else {
            context.currentPreQuery.sideQueries.add(this.entityType.generateQuery(context, base, SCLEntityType.AttributeBinding.EMPTY_ARRAY));
        }
        return this.expression;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.expression.setLocationDeep(loc);
            this.query.setLocationDeep(loc);
        }
    }

    public Expression resolveAttribute(TranslationContext context, long location, String name) {
        SCLEntityType.AttributeBinding binding = (SCLEntityType.AttributeBinding)this.attributeBindingMap.get((Object)name);
        if (binding == null) {
            SCLEntityType.Attribute attribute = this.entityType.getAttribute(name);
            if (attribute == null) {
                context.getErrorLog().log(location, "Attribute " + name + " is not defined in entity type " + this.entityTypeName.text + ".");
                return new EError(location);
            }
            binding = new SCLEntityType.AttributeBinding(attribute, new Variable("#" + name));
            this.attributeBindingMap.put((Object)name, (Object)binding);
        }
        return new EVariable(binding.variable);
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }
}

