/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.elaboration.utils.ExpressionDecorator;
import org.simantics.scl.compiler.internal.interpreted.IExpression;
import org.simantics.scl.compiler.top.ExpressionInterpretationContext;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public class ECHRRuleset
extends Expression {
    CHRRuleset ruleset;
    Expression in;

    public ECHRRuleset(CHRRuleset ruleset, Expression in) {
        this.ruleset = ruleset;
        this.in = in;
    }

    @Override
    public void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
        this.ruleset.collectRefs(allRefs, refs);
        this.in.collectRefs(allRefs, refs);
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        this.ruleset.collectVars(allVars, vars);
        this.in.collectVars(allVars, vars);
    }

    @Override
    public void forVariables(VariableProcedure procedure) {
        this.ruleset.forVariables(procedure);
        this.in.forVariables(procedure);
    }

    @Override
    protected void updateType() throws MatchException {
        this.setType(this.in.getType());
    }

    @Override
    public IVal toVal(Environment env, CodeWriter w) {
        this.ruleset.generateCode(w);
        return this.in.toVal(env, w);
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        this.ruleset.collectFreeVariables(vars);
        this.in.collectFreeVariables(vars);
    }

    @Override
    public Expression resolve(TranslationContext context) {
        context.pushFrame();
        context.pushCHRConstraintFrame();
        this.ruleset.resolve(context);
        this.in = this.in.resolve(context);
        context.popCHRConstraintFrame(this.ruleset.constraints);
        context.popFrame();
        return this;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            this.ruleset.setLocationDeep(loc);
            this.in.setLocationDeep(loc);
        }
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        this.in = this.in.decorate(decorator);
        return this;
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
        this.ruleset.collectEffects(effects);
        this.in.collectEffects(effects);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Expression inferType(TypingContext context) {
        this.ruleset.checkType(context);
        this.in = this.in.inferType(context);
        return this;
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        this.ruleset.simplify(context);
        this.ruleset.compile(context);
        this.in = this.in.simplify(context);
        return this;
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public IExpression toIExpression(ExpressionInterpretationContext context) {
        throw new UnsupportedOperationException();
    }
}

