/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import java.util.ArrayList;
import java.util.LinkedList;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.chr.translation.CHRTranslation;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.expressions.ASTExpression;
import org.simantics.scl.compiler.elaboration.expressions.ECHRRuleset;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.EPreLet;
import org.simantics.scl.compiler.elaboration.expressions.EPreRuleset;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.block.CHRStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.ConstraintStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.GuardStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.RuleStatement;
import org.simantics.scl.compiler.elaboration.expressions.block.Statement;
import org.simantics.scl.compiler.elaboration.expressions.block.StatementGroup;
import org.simantics.scl.compiler.errors.Locations;

public class EBlock
extends ASTExpression {
    LinkedList<Statement> statements = new LinkedList();
    boolean monadic;

    public void addStatement(Statement statement) {
        this.statements.add(statement);
    }

    public void setMonadic(boolean monadic) {
        this.monadic = monadic;
    }

    public LinkedList<Statement> getStatements() {
        return this.statements;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        if (this.statements.isEmpty()) {
            throw new InternalCompilerError();
        }
        int i = this.statements.size() - 1;
        Statement last = this.statements.get(i);
        if (!(last instanceof GuardStatement)) {
            context.getErrorLog().log(last.location, "Block should end with an expression");
            return new EError(this.location);
        }
        Expression in = ((GuardStatement)last).value;
        while (--i >= 0) {
            Statement cur = this.statements.get(i);
            StatementGroup group = cur.getStatementGroup();
            if (group == null) {
                in = cur.toExpression(context, this.monadic, in);
                continue;
            }
            int endId = i + 1;
            while (i > 0 && this.statements.get(i - 1).getStatementGroup() == group) {
                --i;
            }
            switch (group) {
                case LetFunction: {
                    in = this.extractLet(i, endId, in);
                    break;
                }
                case Rule: {
                    in = this.extractRules(i, endId, in);
                    break;
                }
                case CHR: {
                    in = this.extractCHRRules(context, i, endId, in);
                }
            }
        }
        return in.resolve(context);
    }

    private Expression extractRules(int begin, int end, Expression in) {
        return new EPreRuleset(this.statements.subList(begin, end).toArray(new RuleStatement[end - begin]), in);
    }

    private Expression extractCHRRules(TranslationContext context, int begin, int end, Expression in) {
        CHRRuleset ruleset = new CHRRuleset();
        ruleset.location = Locations.combine(this.statements.get((int)begin).location, this.statements.get((int)(end - 1)).location);
        int i = begin;
        while (i < end) {
            Statement statement = this.statements.get(i);
            if (statement instanceof CHRStatement) {
                ruleset.rules.add(CHRTranslation.convertCHRStatement(context, (CHRStatement)statement));
            } else if (statement instanceof ConstraintStatement) {
                ruleset.constraints.add(CHRTranslation.convertConstraintStatement(context, (ConstraintStatement)statement));
            } else {
                throw new InternalCompilerError("Invalid CHR statement.");
            }
            ++i;
        }
        return new ECHRRuleset(ruleset, in);
    }

    private Expression extractLet(int begin, int end, Expression in) {
        return new EPreLet(this.statements.subList(begin, end), in);
    }

    public static Expression create(ArrayList<Expression> statements) {
        EBlock block = new EBlock();
        for (Expression statement : statements) {
            block.addStatement(new GuardStatement(statement));
        }
        return block;
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
            for (Statement statement : this.statements) {
                statement.setLocationDeep(loc);
            }
        }
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    @Override
    public int getSyntacticFunctionArity() {
        if (this.monadic) {
            return 0;
        }
        Statement lastStatement = this.statements.getLast();
        if (!(lastStatement instanceof GuardStatement)) {
            return 0;
        }
        return ((GuardStatement)lastStatement).value.getSyntacticFunctionArity();
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}

