/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.expressions;

import gnu.trove.map.hash.THashMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionTransformer;
import org.simantics.scl.compiler.elaboration.expressions.ExpressionVisitor;
import org.simantics.scl.compiler.elaboration.expressions.SimplifiableExpression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.internal.elaboration.utils.ExpressionDecorator;
import org.simantics.scl.compiler.types.Skeletons;
import org.simantics.scl.compiler.types.TMetaVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.exceptions.UnificationException;
import org.simantics.scl.compiler.types.util.TypeListener;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

public class EAmbiguous
extends SimplifiableExpression {
    public static final boolean DEBUG = false;
    Alternative[] alternatives;
    boolean[] active;
    int activeCount;
    transient TypingContext context;
    Expression resolvedExpression;

    public EAmbiguous(Alternative[] alternatives) {
        this.alternatives = alternatives;
        this.active = new boolean[alternatives.length];
        int i = 0;
        while (i < alternatives.length) {
            this.active[i] = true;
            ++i;
        }
        this.activeCount = alternatives.length;
    }

    @Override
    public void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
    }

    @Override
    public void forVariables(VariableProcedure procedure) {
    }

    @Override
    protected void updateType() throws MatchException {
        throw new InternalCompilerError();
    }

    private Type getCommonSkeleton() {
        Type[] types = new Type[this.activeCount];
        int i = 0;
        int j = 0;
        while (i < this.alternatives.length) {
            if (this.active[i]) {
                types[j++] = Types.instantiateAndStrip(this.alternatives[i].getType());
            }
            ++i;
        }
        return Skeletons.commonSkeleton(this.context.getEnvironment(), types);
    }

    private void filterActive() {
        THashMap unifications = new THashMap();
        Type requiredType = this.getType();
        int i = 0;
        while (i < this.alternatives.length) {
            if (this.active[i]) {
                unifications.clear();
                Type alternativeType = Types.instantiateAndStrip(this.alternatives[i].getType());
                if (!Skeletons.areSkeletonsCompatible((THashMap<TMetaVar, Type>)unifications, alternativeType, requiredType)) {
                    this.active[i] = false;
                    --this.activeCount;
                }
            }
            ++i;
        }
    }

    private String getNoMatchDescription(Type requiredType) {
        StringBuilder b = new StringBuilder();
        b.append("Expected <");
        requiredType.toString(new TypeUnparsingContext(), b);
        b.append(">, but no alteratives match the type: ");
        int i = 0;
        while (i < this.alternatives.length) {
            b.append("\n    ");
            b.append(this.alternatives[i]);
            b.append(" :: ");
            this.alternatives[i].getType().toString(new TypeUnparsingContext(), b);
            ++i;
        }
        b.append('.');
        return b.toString();
    }

    private String getAmbiguousDescription(Type requiredType) {
        StringBuilder b = new StringBuilder();
        b.append("Expected <");
        requiredType.toString(new TypeUnparsingContext(), b);
        b.append(">, but multiple values match the type: ");
        int i = 0;
        while (i < this.alternatives.length) {
            b.append("\n    ");
            b.append(this.alternatives[i]);
            b.append(" :: ");
            this.alternatives[i].getType().toString(new TypeUnparsingContext(), b);
            ++i;
        }
        b.append('.');
        return b.toString();
    }

    private void resolveTo(int i) {
        this.resolvedExpression = this.context.instantiate(this.alternatives[i].realize());
        Type requiredType = this.getType();
        try {
            Types.unify(this.resolvedExpression.getType(), requiredType);
        }
        catch (UnificationException unificationException) {
            this.context.getErrorLog().log(this.location, this.getNoMatchDescription(requiredType));
        }
    }

    private void listenType() {
        new TypeListener(){

            @Override
            public void notifyAboutChange() {
                Type requiredType = EAmbiguous.this.getType();
                EAmbiguous.this.filterActive();
                if (EAmbiguous.this.activeCount == 0) {
                    EAmbiguous.this.context.getErrorLog().log(EAmbiguous.this.location, EAmbiguous.this.getNoMatchDescription(requiredType));
                    return;
                }
                if (EAmbiguous.this.activeCount == 1) {
                    int i = 0;
                    while (i < EAmbiguous.this.alternatives.length) {
                        if (EAmbiguous.this.active[i]) {
                            EAmbiguous.this.resolveTo(i);
                            return;
                        }
                        ++i;
                    }
                }
                Type commonType = EAmbiguous.this.getCommonSkeleton();
                try {
                    Skeletons.unifySkeletons(requiredType, commonType);
                    EAmbiguous.this.listenType();
                }
                catch (UnificationException unificationException) {
                    EAmbiguous.this.context.getErrorLog().log(EAmbiguous.this.location, EAmbiguous.this.getNoMatchDescription(requiredType));
                }
            }
        }.listenSkeleton(this.getType());
    }

    @Override
    public Expression inferType(TypingContext context) {
        this.context = context;
        context.overloadedExpressions.add(this);
        this.setType(this.getCommonSkeleton());
        this.listenType();
        return this;
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
    }

    @Override
    public Expression resolve(TranslationContext context) {
        throw new InternalCompilerError("EAmbiguousConstant should not exist in resolve phase.");
    }

    @Override
    public void setLocationDeep(long loc) {
        if (this.location == 9223372034707292160L) {
            this.location = loc;
        }
    }

    @Override
    public Expression decorate(ExpressionDecorator decorator) {
        return this;
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        if (this.resolvedExpression != null) {
            return this.resolvedExpression;
        }
        context.getErrorLog().log(this.location, this.getAmbiguousDescription(this.getType()));
        return this;
    }

    public void assertResolved(ErrorLog errorLog) {
        if (this.resolvedExpression == null) {
            errorLog.log(this.location, this.getAmbiguousDescription(this.getType()));
        }
    }

    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

    public static abstract class Alternative {
        public abstract Type getType();

        public abstract Expression realize();
    }
}

