/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.compiler.elaboration.chr.relations;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.constants.FunctionValue;
import org.simantics.scl.compiler.constants.JavaMethod;
import org.simantics.scl.compiler.constants.NoRepConstant;
import org.simantics.scl.compiler.constants.generic.CallJava;
import org.simantics.scl.compiler.constants.generic.MethodRef;
import org.simantics.scl.compiler.constants.generic.ParameterStackItem;
import org.simantics.scl.compiler.constants.generic.StackItem;
import org.simantics.scl.compiler.elaboration.chr.CHRRelation;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.chr.plan.PrioritizedPlan;
import org.simantics.scl.compiler.internal.codegen.chr.CHRCodeGenerator;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.internal.codegen.types.StandardTypeConstructor;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.internal.parsing.Symbol;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

public class CHRConstraint
extends Symbol
implements CHRRelation {
    public final String name;
    public final Type[] parameterTypes;
    public boolean implicitlyDeclared;
    public int firstPriorityAdded;
    public int lastPriorityAdded;
    public int firstPriorityRemoved;
    public int lastPriorityRemoved;
    public CHRRuleset parentRuleset;
    public String factClassName;
    public Type factType;
    public TypeDesc factTypeDesc;
    public TCon typeConstructor;
    public Constant constructor;
    public Constant accessId;
    public Constant[] accessors;
    public Constant addProcedure;
    public Constant removeProcedure;
    public Constant isAlive;
    public TIntObjectHashMap<IndexInfo> indices;
    public ArrayList<PrioritizedPlan> plans = new ArrayList();

    public CHRConstraint(long location, String name, Type[] parameterTypes) {
        this.location = location;
        this.name = name;
        this.parameterTypes = parameterTypes;
    }

    public void initializeCodeGeneration(CompilationContext context, CHRRuleset parentRuleset) {
        JavaTypeTranslator jtt = context.javaTypeTranslator;
        this.parentRuleset = parentRuleset;
        this.factClassName = String.valueOf(parentRuleset.storeClassName) + "$" + this.name;
        TCon factTypeConstructor = Types.con(parentRuleset.storeType.module, String.valueOf(parentRuleset.storeType.name) + "$" + this.name);
        this.factType = Types.apply((Type)factTypeConstructor, TVar.EMPTY_ARRAY);
        this.factTypeDesc = TypeDesc.forClass(this.factClassName);
        Type[] constructorTypes = new Type[this.parameterTypes.length + 1];
        constructorTypes[0] = Types.INTEGER;
        ArrayList<ParameterStackItem> stackItems = new ArrayList<ParameterStackItem>(constructorTypes.length);
        stackItems.add(new ParameterStackItem(0, Types.INTEGER));
        int i = 0;
        while (i < this.parameterTypes.length) {
            Type parameterType;
            constructorTypes[i + 1] = parameterType = this.parameterTypes[i];
            if (!parameterType.equals(Types.UNIT)) {
                stackItems.add(new ParameterStackItem(stackItems.size(), parameterType));
            }
            ++i;
        }
        TypeDesc[] constructorTypeDescs = JavaTypeTranslator.filterVoid(jtt.toTypeDescs(constructorTypes));
        this.constructor = new CallJava(TVar.EMPTY_ARRAY, (Type)Types.PROC, this.factType, constructorTypes, stackItems.toArray(new StackItem[stackItems.size()]), new MethodRef.ConstructorRef(this.factClassName, constructorTypeDescs), null);
        this.accessId = new CallJava(TVar.EMPTY_ARRAY, (Type)Types.NO_EFFECTS, (Type)Types.INTEGER, new Type[]{this.factType}, null, new MethodRef.FieldRef(this.factClassName, "id", CHRCodeGenerator.FACT_ID_TYPE), null);
        this.accessors = new Constant[this.parameterTypes.length];
        int i2 = 0;
        while (i2 < this.parameterTypes.length) {
            TypeDesc typeDesc = jtt.toTypeDesc(this.parameterTypes[i2]);
            if (!typeDesc.equals(TypeDesc.VOID)) {
                this.accessors[i2] = new CallJava(TVar.EMPTY_ARRAY, (Type)Types.NO_EFFECTS, this.parameterTypes[i2], new Type[]{this.factType}, null, new MethodRef.FieldRef(this.factClassName, CHRCodeGenerator.fieldName(i2), jtt.toTypeDesc(this.parameterTypes[i2])), null);
            }
            ++i2;
        }
        this.addProcedure = new CallJava(TVar.EMPTY_ARRAY, (Type)Types.PROC, (Type)Types.UNIT, new Type[]{parentRuleset.storeType, this.factType}, new StackItem[]{new ParameterStackItem(1, this.factType), new ParameterStackItem(0, parentRuleset.storeType)}, new MethodRef.ObjectMethodRef(false, this.factClassName, "add", TypeDesc.VOID, new TypeDesc[]{parentRuleset.storeTypeDesc}), null);
        this.indices = new TIntObjectHashMap(Math.min(10, 1 << this.parameterTypes.length));
        if (context.module != null) {
            context.module.addTypeDescriptor(factTypeConstructor.name, new StandardTypeConstructor(factTypeConstructor, TVar.EMPTY_ARRAY, this.factTypeDesc));
        }
    }

    @Override
    public TVar[] getTypeVariables() {
        return TVar.EMPTY_ARRAY;
    }

    @Override
    public Type[] getParameterTypes() {
        return this.parameterTypes;
    }

    public String toString() {
        return this.name;
    }

    public Collection<IndexInfo> getIndices() {
        return this.indices.valueCollection();
    }

    public boolean mayBeRemoved() {
        return this.removeProcedure != null;
    }

    private IndexInfo createIndexInfo(CompilationContext context, int indexMask) {
        FunctionValue accessIndex;
        ArrayList<Type> keyTypeList = new ArrayList<Type>(this.parameterTypes.length + 1);
        keyTypeList.add(this.parentRuleset.storeType);
        int i = 0;
        while (i < this.parameterTypes.length) {
            if ((indexMask >> i & 1) == 1) {
                keyTypeList.add(this.parameterTypes[i]);
            }
            ++i;
        }
        String indexName = CHRConstraint.nameOfIndex(indexMask, this.parameterTypes.length);
        if (indexMask == 0) {
            accessIndex = new CallJava(TVar.EMPTY_ARRAY, (Type)Types.PROC, this.factType, new Type[]{this.parentRuleset.storeType}, null, new MethodRef.FieldRef(this.parentRuleset.storeClassName, String.valueOf(this.name) + "$" + indexName, this.factTypeDesc), null);
        } else {
            Type[] keyTypes = keyTypeList.toArray(new Type[keyTypeList.size()]);
            accessIndex = new JavaMethod(true, this.parentRuleset.storeClassName, String.valueOf(this.name) + "$" + indexName, (Type)Types.PROC, this.factType, keyTypes);
        }
        return new IndexInfo(indexMask, indexName, accessIndex, new CallJava(TVar.EMPTY_ARRAY, (Type)Types.PROC, this.factType, new Type[]{this.factType}, null, new MethodRef.FieldRef(this.factClassName, String.valueOf(indexName) + "Next", this.factTypeDesc), null));
    }

    public IVal fetchFromIndex(CompilationContext context, int boundMask) {
        IndexInfo indexInfo = (IndexInfo)this.indices.get(boundMask);
        if (indexInfo == null) {
            indexInfo = this.createIndexInfo(context, boundMask);
            this.indices.put(boundMask, (Object)indexInfo);
        }
        return indexInfo.firstFact;
    }

    public Constant nextElement(CompilationContext context, int boundMask) {
        IndexInfo indexInfo = (IndexInfo)this.indices.get(boundMask);
        if (indexInfo == null) {
            indexInfo = this.createIndexInfo(context, boundMask);
            this.indices.put(boundMask, (Object)indexInfo);
        }
        return indexInfo.nextFact;
    }

    public static String nameOfIndex(int indexMask, int length) {
        char[] chars = new char[length];
        int i = 0;
        while (i < length) {
            chars[i] = (indexMask >> i & 1) == 1 ? 98 : 102;
            ++i;
        }
        return new String(chars);
    }

    public void setMayBeRemoved() {
        if (this.removeProcedure == null) {
            this.removeProcedure = new CallJava(TVar.EMPTY_ARRAY, (Type)Types.PROC, (Type)Types.UNIT, new Type[]{this.parentRuleset.storeType, this.factType}, new StackItem[]{new ParameterStackItem(1, this.factType), new ParameterStackItem(0, this.parentRuleset.storeType)}, new MethodRef.ObjectMethodRef(false, this.factClassName, "remove", TypeDesc.VOID, new TypeDesc[]{this.parentRuleset.storeTypeDesc}), null);
            this.isAlive = new JavaMethod(true, this.factClassName, "isAlive", (Type)Types.PROC, (Type)Types.BOOLEAN, this.factType);
        }
    }

    public int getMinimumPriority() {
        return this.plans.get((int)0).priority;
    }

    public boolean isPassive() {
        return this.plans.isEmpty();
    }

    @Override
    public TPred[] getTypeConstraints() {
        return TPred.EMPTY_ARRAY;
    }

    public IVal accessComponent(long location, CodeWriter w, IVal fact, int i) {
        Constant accessor = this.accessors[i];
        if (accessor == null) {
            return NoRepConstant.UNIT;
        }
        return w.apply(location, accessor, fact);
    }

    public static class IndexInfo {
        public final int indexMask;
        public final String indexName;
        public final Constant firstFact;
        public final Constant nextFact;

        public IndexInfo(int indexMask, String indexName, Constant firstFact, Constant nextFact) {
            this.indexMask = indexMask;
            this.indexName = indexName;
            this.firstFact = firstFact;
            this.nextFact = nextFact;
        }
    }
}

