package org.simantics.scl.compiler.runtime;

import java.util.Collection;

import gnu.trove.map.hash.THashMap;

public class RuntimeModuleMap {
    THashMap<String, RuntimeModule> moduleMap = new THashMap<String, RuntimeModule>(); 
    
    public RuntimeModule get(String name) {
        return moduleMap.get(name);
    }
    
    public void add(RuntimeModule module) {
        String name = module.module.getName();
        if(!moduleMap.containsKey(name)) {
            moduleMap.put(module.module.getName(), module);
            for(RuntimeModule parentModule : module.parentModuleMap.values())
                add(parentModule);
        }
    }

    public Collection<RuntimeModule> values() {
        return moduleMap.values();
    }

    public int size() {
        return moduleMap.size();
    }
}
