package org.simantics.scl.compiler.parser.generator;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

import org.simantics.scl.compiler.parser.generator.compression.CompressedParseTable;
import org.simantics.scl.compiler.parser.generator.grammar.AnaGrammar;
import org.simantics.scl.compiler.parser.generator.java.GenerateEnum;
import org.simantics.scl.compiler.parser.generator.java.GenerateParser;
import org.simantics.scl.compiler.parser.generator.table.ParseTable;
import org.simantics.scl.compiler.parser.generator.table.ParseTableBuilder;
import org.simantics.scl.compiler.parser.grammar.Grammar;
import org.simantics.scl.compiler.parser.grammar.input.GrammarParserImpl;

public class ParserGenerator {
    
    public static void createParser(String packageName, String exceptionName, File grammarFile) throws IOException {
        // Read grammar and check it
        FileInputStream inputStream = new FileInputStream(grammarFile);
        Grammar grammar = GrammarParserImpl.read(inputStream);
        inputStream.close();
        grammar.check();
        
        AnaGrammar anaGrammar = new AnaGrammar(grammar);
        ParseTable table = ParseTableBuilder.build(anaGrammar);

        File directory = grammarFile.getParentFile();
        String name = grammarFile.getName();
        {
            int p = name.lastIndexOf('.');
            if(p > 0)
                name = name.substring(0, p);
        }

        // Write parse table
        CompressedParseTable compressedTable = table.compress();
        compressedTable.writeTo(new File(directory, name + "Parser.dat"));

        // Write classes
        {
            String className = name + "Terminals"; 
            GenerateEnum.generate(new File(directory, className + ".java"), 
                    packageName, className,
                    anaGrammar.terminalNames);
        }
        {
            String className = name + "Parser";
            new GenerateParser(packageName, className, anaGrammar, exceptionName, compressedTable)
            .generate(new File(directory, className + ".java"));
        }
    }

}
