package org.simantics.scl.compiler.module.coverage;

import java.io.PrintStream;
import java.util.Arrays;

import gnu.trove.map.hash.THashMap;

public class ModuleCoverage extends AbstractCoverage {
    
    public final THashMap<String, FunctionCoverage> functionCoverages;
    
    public final int totalFunctionCount;
    public final int coveredFunctionCount;
    public final double functionCoverage;
    
    public ModuleCoverage(String moduleName, THashMap<String, FunctionCoverage> functionCoverages,
            int totalCodeSize, int coveredCodeSize,
            int totalFunctionCount, int coveredFunctionCount) {
        
        super(moduleName, totalCodeSize, coveredCodeSize);
        this.functionCoverages = functionCoverages;
        this.totalFunctionCount = totalFunctionCount;
        this.coveredFunctionCount = coveredFunctionCount;
        this.functionCoverage = CoverageUtils.safeDiv(coveredFunctionCount, totalFunctionCount);
    }
    
    public void print(PrintStream s) {
        s.println("Code coverage: " + toPercent(getCoverage()) +
                " (" + getCoveredCodeSize() + " / " + getTotalCodeSize() + ")"); 
        s.println("Function coverage: " + toPercent(functionCoverage) +
                " (" + coveredFunctionCount + " / " + totalFunctionCount + ")");
        String[] functionNames = functionCoverages.keySet().toArray(new String[functionCoverages.size()]);
        Arrays.sort(functionNames);
        for(String functionName : functionNames) {
            FunctionCoverage fCov = functionCoverages.get(functionName);
            s.println("    " + functionName + ": " + toPercent(fCov.getCoverage()) +
                    " (" + fCov.coveredCodeSize + " / " + fCov.totalCodeSize + ")");
        }   
    }

}
