package org.simantics.scl.compiler.markdown.nodes;


public class ItemNode extends Node {
    public int indentation;
    
    public ItemNode(int indentation) {
        this.indentation = indentation;
    }

    @Override
    public boolean canContain(Node node) {
        return true;
    }

    public void toHtml(StringBuilder b) {
        toHtml(b, true);
    }
    
    public void toHtml(StringBuilder b, boolean tight) {
        if(firstChild == null) {
            b.append("<li></li>\n");
            return;
        }
        else if(tight) {
            b.append("<li>");
            // This code assumes that there are no consecutive paragraphs
            boolean noNewline = true;
            for(Node child = firstChild; child != null; child = child.next) {
                if(child instanceof ParagraphNode) {
                    for(Node n=child.firstChild;n!=null;n=n.next)
                        n.toHtml(b);
                    noNewline = true;
                }
                else {
                    if(noNewline) {
                        b.append('\n');
                        noNewline = false;
                    }
                    child.toHtml(b);
                }
            }
            b.append("</li>\n");
        }
        else {
            b.append("<li>\n");
            super.toHtml(b);
            b.append("</li>\n");
        }
    }
}
