package org.simantics.scl.compiler.markdown.nodes;

import org.simantics.scl.compiler.markdown.internal.HtmlEscape;

public class CodeBlockNode extends Node {

    public boolean fenced;
    public char fenceChar;
    public int fenceLength;
    public int fenceOffset;
    public String infoString;
    
    public CodeBlockNode() {
    }

    public CodeBlockNode(char fenceChar, int fenceLength, int fenceOffset) {
        this.fenced = true;
        this.fenceChar = fenceChar;
        this.fenceLength = fenceLength;
        this.fenceOffset = fenceOffset;
    }
    
    public CodeBlockNode(StringBuilder stringContent) {
        this.stringContent = stringContent;
    }
    
    @Override
    public boolean acceptLines() {
        return true;
    }
    
    @Override
    public void toHtml(StringBuilder b) {
        if(infoString == null || infoString.isEmpty())
            b.append("<pre><code>");
        else {
            String[] parts = infoString.split(" ");
            b.append("<pre><code class=\"language-").append(parts[0]).append("\">");
        }
        if(stringContent.length() > 0)
            b.append(HtmlEscape.escape(stringContent)).append('\n');
        b.append("</code></pre>\n");
    }
}
