package org.simantics.scl.compiler.markdown.nodes;

import org.simantics.scl.compiler.markdown.internal.HtmlEscape;

public class AutolinkNode extends Node {
    boolean email;
    
    public AutolinkNode(StringBuilder stringContent, boolean email) {
        this.stringContent = stringContent;
        this.email = email;
    }
    
    @Override
    public void toHtml(StringBuilder b) {
        b.append("<a href=\"");
        if(email)
            b.append("mailto:");
        b.append(HtmlEscape.escapeURL(stringContent)).append("\">");
        b.append(HtmlEscape.escape(stringContent));
        b.append("</a>");
    }
}
