package org.simantics.scl.compiler.internal.parsing.declarations;

import java.util.ArrayList;

import org.simantics.scl.compiler.elaboration.query.Query;

import gnu.trove.map.hash.THashMap;

public class DRuleAst extends DeclarationAst {
    public final boolean isAbstract;
    public final String name;
    public final String[] extendsNames;
    private final THashMap<String, ArrayList<Query>> sectionMap =
            new THashMap<String, ArrayList<Query>>(4);
    public boolean alreadyProcessing;

    public DRuleAst(boolean isAbstract, String name, String[] extendsNames) {
        this.isAbstract = isAbstract;
        this.name = name;
        this.extendsNames = extendsNames;
    }
    
    public ArrayList<Query> getSection(String sectionName) {
        ArrayList<Query> result = sectionMap.get(sectionName);
        if(result == null) {
            result = new ArrayList<Query>(4);
            sectionMap.put(sectionName, result);
        }
        return result;
    }
    
    public THashMap<String, ArrayList<Query>> getSections() {
        return sectionMap;
    }
}
