package org.simantics.scl.compiler.internal.parsing.declarations;

import java.util.Collections;
import java.util.List;

import org.simantics.scl.compiler.internal.codegen.types.StandardTypeConstructor;
import org.simantics.scl.compiler.types.kinds.Kind;



public class DDataAst extends DeclarationAst {
    public final String name;
    public final String[] parameters;
    public final ConstructorAst[] constructors;
    public final String[] deriving;
    
    private List<DAnnotationAst> annotations = Collections.emptyList();
    
    // Analyzed data
    public Kind[] parameterKinds;
    //public String javaName;
    public StandardTypeConstructor typeConstructor;
    
    public DDataAst(String name, String[] parameters, ConstructorAst[] constructors, String[] deriving) {
        this.name = name;
        this.parameters = parameters;
        this.constructors = constructors == null ? ConstructorAst.EMPTY_ARRAY : constructors;
        this.deriving = deriving;
    }
    
    public void setAnnotations(List<DAnnotationAst> annotations) {
        this.annotations = annotations;
    }
    
    public List<DAnnotationAst> getAnnotations() {
        return annotations;
    }
    
    @Override
    public void toString(int indentation, StringBuilder b) {
        for(int i=0;i<indentation;++i) b.append("    ");
        b.append("data ");
        b.append(name);
        for(String parameter : parameters) {
            b.append(' ');
            b.append(parameter);
        }
        if(constructors.length > 0) {
            b.append(" = ");        
            for(int i=0;i<constructors.length;++i) {
                if(i > 0)
                    b.append(" | ");
                constructors[i].toString(b);
            }
        }
    }
}
