package org.simantics.scl.compiler.internal.parsing.declarations;

import org.simantics.scl.compiler.internal.parsing.Symbol;
import org.simantics.scl.compiler.internal.parsing.types.TypeAst;


public class ConstructorAst extends Symbol {
    public static final ConstructorAst[] EMPTY_ARRAY = new ConstructorAst[0];
    
    public final DAnnotationAst[] annotations;
    public final String name;
    public final TypeAst[] parameters;
    public final String[] fieldNames; // null, if no field names
    
    public ConstructorAst(DAnnotationAst[] annotations, String name,
            TypeAst[] parameters, String[] fieldNames) {
        this.annotations = annotations;
        this.name = name;
        this.parameters = parameters;
        this.fieldNames = fieldNames;
    }

    public void toString(StringBuilder b) {
        b.append(name);
        for(TypeAst parameter : parameters) {
            b.append(' ');
            parameter.toString(b, 1);
        }
    }
}
