package org.simantics.scl.compiler.internal.codegen.types;

import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TFun;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;

/**
 * Type utilites for SCL compiler backend
 */
public class BTypes {
    
    public static final TCon PROC = Types.con(Types.BUILTIN, "Proc");
 
    public static Type[] matchFunction(Type type, int arity) throws MatchException {
        type = Types.canonical(type);
        /*while(type instanceof TForAll)
            type = ((TForAll)type).type;*/
        Type[] result = new Type[arity+1];
        for(int i=0;i<arity;++i) {
            if(type instanceof TFun) {
                TFun fun = (TFun)type;
                result[i] = fun.domain;
                type = Types.canonical(fun.range);
            }
            /*else if(type instanceof TApply) {
                TApply apply1 = (TApply)type;
                Type function1 = Types.canonical(apply1.function);
                if(function1 instanceof TApply) {
                    TApply apply2 = (TApply)function1;
                    Type function2 = Types.canonical(apply2.function);
                    if(function2 == Types.ARROW) {
                        result[i] = apply2.parameter;
                        type = Types.canonical(apply1.parameter);
                    }
                    else
                        throw new MatchException();
                }
                else
                    throw new MatchException();
            }*/
            else
                throw new MatchException();
        }
        result[arity] = type;
        return result;
    }

}
