package org.simantics.scl.compiler.internal.codegen.chr;

import org.simantics.scl.runtime.chr.CHRHashIndex;
import org.simantics.scl.runtime.chr.Fact;
import org.simantics.scl.runtime.chr.FactActivationQueue;

public class ExampleStore {
    /*
     * constraint ExampleFact Integer Integer where
     *     index(bf)
     *     
     * =>
     * 
     * data Store       // class Module$123
     * data ExampleFact // class Module$123/ExampleFact
     * 
     * add     :: Store -> ExampleFact -> <Proc> ()
     * remove  :: Store -> ExampleFact -> <Proc> ()
     * get_bf  :: Store -> Integer -> <Proc> ExampleFact
     * next_bf :: ExampleFact -> <Proc> Maybe ExampleFact
     * idOf    :: ExampleFact -> <Proc> Integer
     * isAlive :: ExampleFact -> <Proc> Boolean
     */
    
    CHRHashIndex ExampleFact_bfIndex = new CHRHashIndex() {
        @Override
        protected boolean keyEquals(Object a, Object b) {
            return ((ExampleFact)a).c0 == ((ExampleFact)b).c0;
        }
        @Override
        protected int keyHashCode(Object key) {
            return ((ExampleFact)key).c0;
        }
    };
    
    public FactActivationQueue queue = new FactActivationQueue(2);
    
    private ExampleFact ExampleFact_temp = new ExampleFact();
        
    public ExampleFact getExampleFact_bf(int c0) {
        ExampleFact_temp.c0 = c0;
        return (ExampleFact)ExampleFact_bfIndex.getEqual(ExampleFact_temp);
    }
    
    public static class ExampleFact implements Fact {
        public int id;
        public int c0; // key
        public int c1;
        public ExampleFact bfPrev;
        public ExampleFact bfNext;
        
        public ExampleFact() {
        }
        
        public ExampleFact(int c0, int c1) {
            this.c0 = c0;
            this.c1 = c1;
        }
        
        public void add(ExampleStore store) {
            bfNext = (ExampleFact)store.ExampleFact_bfIndex.addFreshAndReturnOld(this);
            if(bfNext != null)
                bfNext.bfPrev = this;
        }
        
        public void remove(ExampleStore store) {
            if(bfPrev == null) {
                if(bfNext == null)
                    store.ExampleFact_bfIndex.removeKnownToExistKey(this);
                else {
                    bfNext.bfPrev = null;
                    store.ExampleFact_bfIndex.replaceKnownToExistKey(this, bfNext);
                }
            }
            else {
                bfPrev.bfNext = bfNext;
                if(bfNext != null)
                    bfNext.bfPrev = bfPrev;
            }
        }

        @Override
        public int activate(Object context, int priority) {
            return -1;
        }

        @Override
        public boolean isAlive() {
            return id >= 0;
        }
    }

}
