package org.simantics.scl.compiler.environment.filter;

import gnu.trove.set.hash.THashSet;

public class NegativeNamespaceFilter implements NamespaceFilter {
    THashSet<String> excludedValues;

    public NegativeNamespaceFilter(THashSet<String> excludedValues) {
        this.excludedValues = excludedValues;
    }

    @Override
    public boolean isValueIncluded(String name) {
        return !excludedValues.contains(name);
    }
    
    @Override
    public String toString() {
        return "Exclude" + excludedValues.toString();
    }

    @Override
    public boolean isSubsetOf(NamespaceFilter filter) {
        if(filter == AcceptAllNamespaceFilter.INSTANCE)
            return true;
        if(filter instanceof NegativeNamespaceFilter) {
            NegativeNamespaceFilter other = (NegativeNamespaceFilter)filter;
            for(String name : other.excludedValues)
                if(!excludedValues.contains(name))
                    return false;
            return true;
        }
        return false;
    }
}
