package org.simantics.scl.compiler.elaboration.modules;

import java.util.ArrayList;

import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.constants.JavaTypeClassSuper;
import org.simantics.scl.compiler.elaboration.fundeps.Fundep;
import org.simantics.scl.compiler.internal.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;

import gnu.trove.map.hash.THashMap;

public class TypeClass extends TypeConstructor {
    public final TPred[] context;
    public final TCon name;
    public final String javaName;
    public final TVar[] parameters;
    public final Fundep[] fundeps;
    public final TPred class_;    
    public final ArrayList<String> methodNames = new ArrayList<String>(); 
    public final THashMap<String, TypeClassMethod> methods = 
            new THashMap<String, TypeClassMethod>();
    public final Constant[] superGenerators;
    public final TypeDesc typeDesc;
    long locatable;
    public String documentation;
    
    public TypeClass(long loc, TPred[] context, TCon name, String javaName, TVar[] parameters,
            Fundep[] fundeps) {
        super(Kinds.STAR);
        this.locatable = loc;
        this.context = context;        
        this.name = name;
        this.javaName = javaName;
        this.parameters = parameters;
        this.fundeps = fundeps;
        //this.typeDesc = TypeDesc.forClass(new JavaNamingPolicy(name.module).getTypeClassInterfaceName(name));
        this.typeDesc = TypeDesc.forClass(javaName);
        this.class_ = Types.pred(name, parameters);
        this.superGenerators = new Constant[context.length];
        for(int i=0;i<context.length;++i)
            superGenerators[i] = new JavaTypeClassSuper(i, javaName, "super" + i, context[i], class_);
    }

    /*
    public void toString(final StringBuilder b) {
        final TypeUnparsingContext tuc = new TypeUnparsingContext();
        b.append("class (");
        for(int i=0;i<context.length;++i) {
            if(i>0)
                b.append(", ");
            context[i].toString(tuc);
            b.append(context[i]);
        }
        b.append(") => ");
        b.append(class_.toString(tuc));
        b.append(" where\n");
        methods.forEachValue(new TObjectProcedure<TypeClassMethod>() {            
            @Override
            public boolean execute(TypeClassMethod method) {
                b.append("    ");
                b.append(method.name);
                b.append(" :: ");
                b.append(method.baseType.toString(tuc));
                b.append('\n');
                return true;
            }
        });
    }
    */
    
    @Override
    public TypeDesc construct(JavaTypeTranslator translator, Type[] parameters) {
        return typeDesc;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }
}
