package org.simantics.scl.compiler.elaboration.expressions.list;

import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.elaboration.utils.ExpressionDecorator;
import org.simantics.scl.compiler.types.Type;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;

public class ListSeq extends ListQualifier {
    public ListQualifier a;
    public ListQualifier b;
    
    public ListSeq(ListQualifier a, ListQualifier b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public void checkType(TypingContext context) {
        a.checkType(context);
        b.checkType(context);  
    }
    
    @Override
    public void collectRefs(TObjectIntHashMap<Object> allRefs,
            TIntHashSet refs) {
        a.collectRefs(allRefs, refs);
        b.collectRefs(allRefs, refs);
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars,
            TIntHashSet vars) {
        a.collectVars(allVars, vars);
        b.collectVars(allVars, vars);
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        b.collectFreeVariables(vars);
        a.collectFreeVariables(vars);
    }

    @Override
    public CompiledQualifier compile(SimplificationContext context) {
        CompiledQualifier cA = a.compile(context);
        CompiledQualifier cB = b.compile(context);      
        
        Variable x = new Variable("xTemp", cA.pattern.getType());
        Variable y = new Variable("yTemp", cB.pattern.getType());
        
        Expression value = context.concatMap( 
                context.lambda(context.var(x), context.mapList(
                        context.lambda(context.var(y), context.tuple(context.var(x), context.var(y))),
                        context.match(context.var(x), cA.pattern, cB.value))), 
                        cA.value);
        /*try {
            value.validateType(context.getEnvironment());
        } catch (TypeValidationException e) {
            e.printStackTrace();
        }*/
        return new CompiledQualifier(value, context.tuple(cA.pattern, cB.pattern));
    }

    @Override
    public void resolve(TranslationContext context) {
        a.resolve(context);
        b.resolve(context);
    }
    
    @Override
    public void decorate(ExpressionDecorator decorator) {
        a.decorate(decorator);
        b.decorate(decorator);
    }
    
    @Override
    public void collectEffects(THashSet<Type> effects) {
        a.collectEffects(effects);
        b.collectEffects(effects);
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            a.setLocationDeep(loc);
            b.setLocationDeep(loc);
        }
    }
    
    @Override
    public void accept(ListQualifierVisitor visitor) {
        visitor.visit(this);
    }
    
    @Override
    public void forVariables(VariableProcedure procedure) {
        a.forVariables(procedure);
        b.forVariables(procedure);
    }
    
    @Override
    public ListQualifier accept(ListQualifierTransformer transformer) {
        return transformer.transform(this);
    }
}
