package org.simantics.scl.compiler.elaboration.expressions.list;

import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.internal.elaboration.utils.ExpressionDecorator;
import org.simantics.scl.compiler.internal.parsing.Symbol;
import org.simantics.scl.compiler.types.Type;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;

public abstract class ListQualifier extends Symbol {

    public abstract void checkType(TypingContext context);
    public abstract void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs);
    public abstract void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars);
    public abstract void collectFreeVariables(THashSet<Variable> vars);
    public abstract CompiledQualifier compile(SimplificationContext context);
    public abstract void resolve(TranslationContext context);
    public abstract void decorate(ExpressionDecorator decorator);
    public abstract void collectEffects(THashSet<Type> effects);
    public abstract void setLocationDeep(long loc);
    public abstract void accept(ListQualifierVisitor visitor);
    public abstract ListQualifier accept(ListQualifierTransformer transformer);
    public abstract void forVariables(VariableProcedure procedure);
    
}
