package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.internal.elaboration.utils.ExpressionDecorator;
import org.simantics.scl.compiler.types.Type;

public class Assignment {
    public Expression pattern;
    public Expression value;
    
    public Assignment(Expression pattern, Expression value) {
        if(Type.NULL_CHECKS) {
            if(pattern == null)
                throw new NullPointerException();
            if(value == null)
                throw new NullPointerException();
        }
        this.pattern = pattern;
        this.value = value;
    }

    public Assignment replace(ReplaceContext context) {
        Expression newPattern = pattern.replaceInPattern(context);
        Expression newValue = value.replace(context);
        return new Assignment(newPattern, newValue);
    }

    public void decorate(ExpressionDecorator decorator) {
        pattern = pattern.decorate(decorator);
        value = value.decorate(decorator);
    }

    public void setLocationDeep(long loc) {
        pattern.setLocationDeep(loc);
        value.setLocationDeep(loc);
    }

    public void forVariables(VariableProcedure procedure) {
        value.forVariables(procedure);
    }
}
