package org.simantics.scl.compiler.elaboration.equation;

import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.VariableProcedure;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.elaboration.utils.ExpressionDecorator;
import org.simantics.scl.compiler.types.Type;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.THashSet;
import gnu.trove.set.hash.TIntHashSet;

public class EqGuard extends Equation {
    public Expression guard;

    public EqGuard(Expression guard) {
        this.guard = guard;
    }
    
    public EqGuard(long location, Expression guard) {
        this(guard);
        this.location = location;
    }

    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            guard.setLocationDeep(loc);
        }
    }

    @Override
    public void forVariables(VariableProcedure procedure) {
        guard.forVariables(procedure);
    }

    @Override
    public void collectFreeVariables(THashSet<Variable> vars) {
        guard.collectFreeVariables(vars);
    }

    @Override
    public void decorate(ExpressionDecorator decorator) {
        guard = guard.decorate(decorator);
    }

    @Override
    public void collectEffects(THashSet<Type> effects) {
        guard.collectEffects(effects);
    }

    @Override
    public void checkType(TypingContext context) {
        guard = guard.checkIgnoredType(context);
    }

    @Override
    public void collectRefs(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
        guard.collectRefs(allRefs, refs);
    }

    @Override
    public void collectVars(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        guard.collectVars(allVars, vars);
    }

    @Override
    public void resolve(TranslationContext context) {
        guard = guard.resolve(context);
    }
    
    @Override
    public void accept(EquationVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Equation replace(ReplaceContext context) {
        return new EqGuard(location, guard.replace(context));
    }
}
