package org.simantics.scl.compiler.compilation;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.elaboration.modules.TypeClass;
import org.simantics.scl.compiler.elaboration.modules.TypeClassInstance;
import org.simantics.scl.compiler.elaboration.modules.TypeDescriptor;
import org.simantics.scl.compiler.elaboration.relations.SCLEntityType;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;
import org.simantics.scl.compiler.elaboration.rules.TransformationRule;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.Namespace;
import org.simantics.scl.compiler.internal.codegen.effects.EffectConstructor;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.types.TCon;

public class EnvironmentOfModule implements Environment {
    Environment base;
    Module module;
    Namespace localNamespace;
    
    public EnvironmentOfModule(Environment base, Module module) {
        this.base = base;
        this.module = module;
        this.localNamespace = new NamespaceOfModule(base.getLocalNamespace(), module);
    }

    @Override
    public Namespace getLocalNamespace() {
        return localNamespace;
    }
    
    @Override
    public SCLValue getValue(Name name) {
        if(name.module.equals(module.getName()))
            return module.getValue(name.name);
        else
            return base.getValue(name);
    }
    @Override
    public SCLRelation getRelation(Name name) {
        if(name.module.equals(module.getName()))
            return module.getRelation(name.name);
        else
            return base.getRelation(name);
    }
    @Override
    public SCLEntityType getEntityType(Name name) {
        if(name.module.equals(module.getName()))
            return module.getEntityType(name.name);
        else
            return base.getEntityType(name);
    }
    @Override
    public TypeDescriptor getTypeDescriptor(TCon type) {
        if(type.module.equals(module.getName()))
            return module.getTypeDescriptor(type.name);
        else
            return base.getTypeDescriptor(type);
    }
    @Override
    public EffectConstructor getEffectConstructor(TCon type) {
        if(type.module.equals(module.getName()))
            return module.getEffectConstructor(type.name);
        else
            return base.getEffectConstructor(type);
    }
    @Override
    public TypeClass getTypeClass(TCon type) {
        if(type.module.equals(module.getName()))
            return module.getTypeClass(type.name);
        else
            return base.getTypeClass(type);
    }
    @Override
    public Collection<TypeClassInstance> getInstances(TCon typeClass) {
        Collection<TypeClassInstance> inst1 = module.getInstances(typeClass);
        Collection<TypeClassInstance> inst2 = base.getInstances(typeClass);
        if(inst1.isEmpty())
            return inst2;
        if(inst2.isEmpty())
            return inst1;
        ArrayList<TypeClassInstance> union = new ArrayList<TypeClassInstance>(inst1.size() + inst2.size());
        union.addAll(inst1);
        union.addAll(inst2);
        return union;
    }
    
    @Override
    public void collectRules(Collection<TransformationRule> rules) {
        base.collectRules(rules);
        rules.addAll(module.getRules());
    }
}
