package org.simantics.scl.compiler.compilation;

import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EError;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.errors.ErrorLog;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.codegen.types.JavaTypeTranslator;
import org.simantics.scl.compiler.internal.codegen.utils.JavaNamingPolicy;
import org.simantics.scl.compiler.module.ConcreteModule;
import org.simantics.scl.compiler.types.Type;

import gnu.trove.map.hash.THashMap;

public class CompilationContext implements EnvironmentalContext {
    public final ErrorLog errorLog = new ErrorLog();
    public Environment environment;
    public JavaTypeTranslator javaTypeTranslator;
    public JavaNamingPolicy namingPolicy;
    public ConcreteModule module;
    
    private THashMap<Name, SCLValue> valueCache = new THashMap<Name, SCLValue>();

    public SCLValue getValue(Name name) {
        if(valueCache.containsKey(name))
            return valueCache.get(name);
        SCLValue value = environment.getValue(name);
        if(value == null)
            errorLog.log(Locations.NO_LOCATION, "Couldn't find " + name + ".");
        valueCache.put(name, value);
        return value;
    }
    
    public Expression getConstant(Name name, Type ... typeParameters) {
        SCLValue value = getValue(name);
        if(value == null)
            return new EError(Locations.NO_LOCATION);
        return new EConstant(value, typeParameters);
    }
}
