package org.simantics.scl.compiler.commands;

import java.util.Collection;

public class CommandSessionImportEntry implements Comparable<CommandSessionImportEntry> {
    public String moduleName;
    public String localName;
    
    public boolean persistent;
    public boolean hasError;
    public boolean disabled;
    
    public CommandSessionImportEntry(String moduleName, String localName,
            boolean persistent) {
        this.moduleName = moduleName;
        this.localName = localName;
        this.persistent = persistent;
    }

    public CommandSessionImportEntry(String moduleName, String localName) {
        this.moduleName = moduleName;
        this.localName = localName;
    }

    public CommandSessionImportEntry(String moduleName) {
        this(moduleName, "");
    }
    
    public void addTo(Collection<CommandSessionImportEntry> entries) {
        for(CommandSessionImportEntry entry : entries)
            if(entry.moduleName.equals(moduleName) && entry.localName.equals(localName)) {
                entry.persistent |= persistent;
                entry.disabled &= disabled;
                return;
            }
        entries.add(this);
    }

    @Override
    public int compareTo(CommandSessionImportEntry o) {
        int cmp = moduleName.compareTo(o.moduleName);
        if(cmp != 0)
            return cmp;
        return localName.compareTo(o.localName);
    }

    public String getStatusString() {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        if(persistent) {
            first = false;
            b.append("persistent");
        }
        if(disabled) {
            if(first)
                first = false;
            else
                b.append(", ");
            b.append("disabled");
        }
        if(hasError) {
            if(first)
                first = false;
            else
                b.append(", ");
            b.append("has errors");
        }
        return b.toString();
    }
}
