/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.g2d.events.EventTypes;
import org.simantics.scenegraph.g2d.events.MouseEvent.MouseClickEvent;
import org.simantics.scenegraph.g2d.events.MouseEvent.MouseMovedEvent;
import org.simantics.scenegraph.utils.DummyComponent;
import org.simantics.scenegraph.utils.NodeUtil;

public class BooleanToggleValueNode extends G2DNode implements ActionListener {
    private static final long serialVersionUID = 3255791584573492072L;

    protected static final BasicStroke STROKE = new BasicStroke(1.0f);
    protected static final Rectangle2D BOUNDS = new Rectangle2D.Double(-10, -10, 20, 20);

    protected Boolean value = null;
    protected transient boolean mouseOver = false;

    @Override
    public void init() {
        super.init();
        addEventHandler(this);
    }

    @SyncField("value")
    public void setValue(Boolean value) {
        this.value = value;
    }

    @Override
    public void render(Graphics2D g) {
        Color borderColor = new Color(160, 10, 10);
        Color fillColor   = new Color(210, 10, 10);
        boolean in = false;
        if(value != null && value) {
            borderColor = new Color(10, 160, 10);
            fillColor   = new Color(10, 210, 10);
            in = true;
        }

        if(mouseOver) borderColor = borderColor.darker();
        AffineTransform ot = g.getTransform();

        g.transform(transform);

        g.setColor(fillColor);
        g.fill(BOUNDS);

        g.setStroke(STROKE);
        g.setColor(in ? borderColor.darker().darker() : borderColor);
        g.draw(new Line2D.Double(BOUNDS.getMinX(), BOUNDS.getMinY(), BOUNDS.getMinX(), BOUNDS.getMaxY()));
        g.draw(new Line2D.Double(BOUNDS.getMinX(), BOUNDS.getMinY(), BOUNDS.getMaxX(), BOUNDS.getMinY()));

        g.setColor(in ? borderColor : borderColor.darker().darker());
        g.draw(new Line2D.Double(BOUNDS.getMaxX(), BOUNDS.getMinY(), BOUNDS.getMaxX(), BOUNDS.getMaxY()));
        g.draw(new Line2D.Double(BOUNDS.getMinX(), BOUNDS.getMaxY(), BOUNDS.getMaxX(), BOUNDS.getMaxY()));

        g.setTransform(ot);
    }

    /**
     * Helper method to be used inside MonitorClass
     * @return
     */
    public static Shape getOutline() {
        return BOUNDS;
    }

    @Override
    public Rectangle2D getBoundsInLocal() {
        return BOUNDS;
    }

    protected transient ActionListener actionListener = null;

    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    @ServerSide
    @Override
    public void actionPerformed(ActionEvent e) {
        if(actionListener != null) {
            actionListener.actionPerformed(e);
        }
    }

    @Override
    protected boolean mouseClicked(MouseClickEvent e) {
        Point2D pt = NodeUtil.worldToLocal(this, e.controlPosition, new Point2D.Double());
        if (BOUNDS.contains(pt)) {
            setValue((value == null || value == false) ? true :  false); // Toggle value
            actionPerformed(new ActionEvent(new DummyComponent(), ActionEvent.ACTION_PERFORMED, ""+value));
            repaint();
            return true;
        }
        return false;
    }

    @Override
    protected boolean mouseMoved(MouseMovedEvent e) {
        Point2D pt = NodeUtil.worldToLocal(this, e.controlPosition, new Point2D.Double());
        boolean tmp = mouseOver;
        mouseOver = BOUNDS.contains(pt);
        if (tmp != mouseOver)
            repaint();
        return false;
    }

    @Override
    public int getEventMask() {
        return EventTypes.MouseMovedMask | EventTypes.MouseClickMask;
    }

}
