/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d;

import java.awt.RenderingHints.Key;

import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfWriter;

/**
 * @author Toni Kalajainen
 */
public final class G2DPDFRenderingHints {

    /** A rendering hint for storing the ExportPdfWriter object. */
    public static final Key KEY_EXPORT_PDF_WRITER = new Key(2003) {
        @Override
        public boolean isCompatibleValue(Object val) {
            return val.getClass().getName().equals("org.simantics.export.core.pdf.ExportPdfWriter");
        }
    };
	
    /**
     * A rendering hint for storing the root PDF ByteContent on which the scene
     * graph is rendered within a Graphics2D instance.
     */
    public static final Key KEY_PDF_BYTECONTENT = new Key(2000) {
        @Override
        public boolean isCompatibleValue(Object val) {
            return val instanceof PdfContentByte;
        }
    };

    /**
     * A rendering hint for storing the root PDF writer on which the scene
     * graph is rendered within a Graphics2D instance.
     */
    public static final Key KEY_PDF_WRITER = new Key(2001) {
        @Override
        public boolean isCompatibleValue(Object val) {
            return val instanceof PdfWriter;
        }
    };
    
    /**
     * A rendering hint for storing the root PDF Font Mapper on which the scene
     * graph is rendered within a Graphics2D instance.
     */
    public static final Key KEY_PDF_FONTMAPPER = new Key(2002) {
        @Override
        public boolean isCompatibleValue(Object val) {
            return val instanceof FontMapper;
        }
    };
    

}