package org.simantics.modeling.ui.scl.imports;

import java.util.ArrayList;
import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;

public class SCLModulesQuery extends UnaryRead<Resource, Collection<String>> {

    public SCLModulesQuery(Resource parameter) {
        super(parameter);
    }

    @Override
    public Collection<String> perform(ReadGraph graph) throws DatabaseException {
        ArrayList<String> result = new ArrayList<String>(); 
        
        Layer0 L0 = Layer0.getInstance(graph);
        browse(graph, L0, parameter, result);
        
        return result;
    }

    private static void browse(ReadGraph graph, Layer0 L0, Resource current,
            ArrayList<String> result) throws DatabaseException {
        if(graph.isInstanceOf(current, L0.SCLModule))
            result.add(graph.getURI(current));
        else if(graph.isInstanceOf(current, L0.Library)
                || graph.isInstanceOf(current, L0.IndexRoot)) {
            for(Resource child : graph.getObjects(current, L0.ConsistsOf))
                browse(graph, L0, child, result);
        }
    }

}
