package org.simantics.modeling.ui.scl.imports;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Shell;
import org.simantics.Simantics;
import org.simantics.scl.compiler.commands.CommandSessionImportEntry;
import org.simantics.scl.ui.imports.ImportModulesAction;

public class SCLModulesImportModulesAction extends ImportModulesAction {
    
    public static final SCLModulesImportModulesAction INSTANCE = new SCLModulesImportModulesAction();
            
    public SCLModulesImportModulesAction() {
        super("Add modules from project", 20.0);
    }

    @Override
    public boolean editImports(Shell shell, ArrayList<CommandSessionImportEntry> imports) {
        ModuleSelectionDialog dialog = new ModuleSelectionDialog(shell,
                new SCLModulesQuery(Simantics.getProjectResource()));
        if(dialog.open() == Dialog.OK) {
            for(Object r : dialog.getResult()) {
                String uri = (String)r;
                new CommandSessionImportEntry(uri, "", true).addTo(imports);
            }
            return true;
        }
        else
            return false;
    }

}
