package org.simantics.modeling.ui.scl.imports;

import java.util.Collection;
import java.util.Comparator;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;
import org.simantics.Simantics;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.modeling.ui.Activator;
import org.simantics.utils.ui.dialogs.ShowError;

public class ModuleSelectionDialog extends FilteredItemsSelectionDialog {

    private static final String SCL_MODULE_SELECTION_DIALOG = "SCL_MODULE_SELECTION_DIALOG";
    
    Read<Collection<String>> query;
    
    public ModuleSelectionDialog(Shell shell, Read<Collection<String>> query) {
        super(shell, true);
        this.query = query;
    }

    @Override
    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    @Override
    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getDefault()
                .getDialogSettings().getSection(SCL_MODULE_SELECTION_DIALOG);
        if (settings == null)
            settings = Activator.getDefault()
            .getDialogSettings().addNewSection(SCL_MODULE_SELECTION_DIALOG);
        return settings;
    }

    @Override
    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    @Override
    protected ItemsFilter createFilter() {
        return new ItemsFilter() {
            {
                String patternText = getPattern();
                patternMatcher = new SearchPattern();
                if(patternText != null && patternText.length() > 0)
                    patternMatcher.setPattern(patternText);
                else 
                    patternMatcher.setPattern("*");
            }
            
            @Override
            public boolean matchItem(Object item) {
                if(getPattern().indexOf('/') > 0)
                    return matches((String)item);
                else {
                    for(String part : ((String)item).split("/"))
                        if(matches(part))
                            return true;
                    return false;
                }
            }

            @Override
            public boolean isConsistentItem(Object item) {
                return true;
            }
            
        };
    }

    Comparator<String> comparator = new Comparator<String>() {
        @Override
        public int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    };
    
    @SuppressWarnings("rawtypes")
    @Override
    protected Comparator getItemsComparator() {
        return comparator;
    }

    @Override
    protected void fillContentProvider(final AbstractContentProvider contentProvider,
            final ItemsFilter itemsFilter, IProgressMonitor progressMonitor)
            throws CoreException {
        try {
            for(String module : Simantics.getSession().syncRequest(query,
                    TransientCacheListener.<Collection<String>>instance()))
                contentProvider.add(module, itemsFilter);
        } catch (DatabaseException e) {
            ShowError.showError("Failed to find modules",
                    "Exception was thrown during search for modules", e);
            close();
        }

        if(progressMonitor != null)
            progressMonitor.done();
    }

    @Override
    public String getElementName(Object item) {
        return (String)item;
    }

}
