/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.preferences;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.simantics.g2d.page.DiagramDesc;
import org.simantics.utils.page.MarginUtils.Margin;
import org.simantics.utils.page.MarginUtils.Margins;
import org.simantics.utils.page.PageDesc;
import org.simantics.utils.page.PageOrientation;

/**
 * @author Tuukka Lehtonen
 */
public final class DiagramPreferences {

    public static final String             P_SNAP_GRID_SIZE           = "grid.size";
    public static final String             P_DEFAULT_PAGE_SIZE        = "page.default.size";
    public static final String             P_DISPLAY_PAGE_SIZE        = "page.display.size";
    public static final String             P_DISPLAY_MARGINS          = "page.display.margins";
    public static final String             P_DISPLAY_GRID             = "page.display.grid";
    public static final String             P_DISPLAY_RULER            = "page.display.ruler";

    public static final Margin             MARGIN_10MM                = new Margin(0, 0, 10);

    public static final Double             DEFAULT_SNAP_GRID_SIZE     = 1.0;
    public static final PageOrientation    DEFAULT_PAGE_ORIENTATION   = PageOrientation.Landscape;
    public static final Margins            DEFAULT_PAGE_MARGINS       = new Margins(MARGIN_10MM, MARGIN_10MM, MARGIN_10MM, MARGIN_10MM);
    public static final PageDesc           DEFAULT_PAGE_SIZE          = PageDesc.DEFAULT.withOrientation(DEFAULT_PAGE_ORIENTATION).withMargins(DEFAULT_PAGE_MARGINS);
    public static final Boolean            DEFAULT_DISPLAY_PAGE_SIZE  = Boolean.TRUE;
    public static final Boolean            DEFAULT_DISPLAY_MARGINS    = Boolean.TRUE;
    public static final Boolean            DEFAULT_DISPLAY_GRID       = Boolean.FALSE;
    public static final Boolean            DEFAULT_DISPLAY_RULER      = Boolean.FALSE;

    public final IEclipsePreferences       preferences;

    private final Map<String, Object>      map;

    public DiagramPreferences(IEclipsePreferences preferences, Map<String, Object> map) {
        this.preferences = preferences;
        this.map = map;
        if (map == null)
            map = Collections.emptyMap();
    }

    public DiagramPreferences withValue(String preference, Object value) {
        Map<String, Object> newMap = new HashMap<String, Object>(map);
        newMap.put(preference, value);
        return new DiagramPreferences(preferences, newMap);
    }

    @SuppressWarnings("unchecked")
    public <T> T get(String preference) {
        T t = (T) map.get(preference);
        if (t == null)
            throw new IllegalStateException("no value for preference " + preference + " available");
        return t;
    }

    public PageDesc getCompletePageDesc() {
        PageDesc pd = get(P_DEFAULT_PAGE_SIZE);
        return pd;
//        PageOrientation po = get(P_DEFAULT_PAGE_ORIENTATION);
//        Margins margins = get(P_DEFAULT_PAGE_MARGINS);
//        return pd.withOrientation(po).withMargins(margins);
    }

    public DiagramDesc getDiagramDesc() {
        double gridSize = get(DiagramPreferences.P_SNAP_GRID_SIZE);
        boolean bordersVisible = get(DiagramPreferences.P_DISPLAY_PAGE_SIZE);
        boolean marginsVisible = get(DiagramPreferences.P_DISPLAY_MARGINS);
        boolean gridVisible = get(DiagramPreferences.P_DISPLAY_GRID);
        boolean rulerVisible = get(DiagramPreferences.P_DISPLAY_RULER);
        return new DiagramDesc(getCompletePageDesc(), gridSize, bordersVisible, marginsVisible, gridVisible, rulerVisible);
    }

}
